// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Parameters for Reimaging Virtual Machine. NOTE: Virtual Machine OS disk will always be reimaged. */
@Fluent
public class VirtualMachineReimageParameters {
    /*
     * Specifies whether to reimage temp disk. Default value: false. Note: This temp disk reimage parameter is only
     * supported for VM/VMSS with Ephemeral OS disk.
     */
    @JsonProperty(value = "tempDisk")
    private Boolean tempDisk;

    /**
     * Get the tempDisk property: Specifies whether to reimage temp disk. Default value: false. Note: This temp disk
     * reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
     *
     * @return the tempDisk value.
     */
    public Boolean tempDisk() {
        return this.tempDisk;
    }

    /**
     * Set the tempDisk property: Specifies whether to reimage temp disk. Default value: false. Note: This temp disk
     * reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
     *
     * @param tempDisk the tempDisk value to set.
     * @return the VirtualMachineReimageParameters object itself.
     */
    public VirtualMachineReimageParameters withTempDisk(Boolean tempDisk) {
        this.tempDisk = tempDisk;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
