// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Specifies additional capabilities supported by the image. */
@Fluent
public final class VirtualMachineImageFeature {
    /*
     * The name of the feature.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The corresponding value for the feature.
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Get the name property: The name of the feature.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the feature.
     *
     * @param name the name value to set.
     * @return the VirtualMachineImageFeature object itself.
     */
    public VirtualMachineImageFeature withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The corresponding value for the feature.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The corresponding value for the feature.
     *
     * @param value the value value to set.
     * @return the VirtualMachineImageFeature object itself.
     */
    public VirtualMachineImageFeature withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
