// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Information about the number of virtual machine instances in each upgrade state. */
@Immutable
public final class RollingUpgradeProgressInfo {
    /*
     * The number of instances that have been successfully upgraded.
     */
    @JsonProperty(value = "successfulInstanceCount", access = JsonProperty.Access.WRITE_ONLY)
    private Integer successfulInstanceCount;

    /*
     * The number of instances that have failed to be upgraded successfully.
     */
    @JsonProperty(value = "failedInstanceCount", access = JsonProperty.Access.WRITE_ONLY)
    private Integer failedInstanceCount;

    /*
     * The number of instances that are currently being upgraded.
     */
    @JsonProperty(value = "inProgressInstanceCount", access = JsonProperty.Access.WRITE_ONLY)
    private Integer inProgressInstanceCount;

    /*
     * The number of instances that have not yet begun to be upgraded.
     */
    @JsonProperty(value = "pendingInstanceCount", access = JsonProperty.Access.WRITE_ONLY)
    private Integer pendingInstanceCount;

    /**
     * Get the successfulInstanceCount property: The number of instances that have been successfully upgraded.
     *
     * @return the successfulInstanceCount value.
     */
    public Integer successfulInstanceCount() {
        return this.successfulInstanceCount;
    }

    /**
     * Get the failedInstanceCount property: The number of instances that have failed to be upgraded successfully.
     *
     * @return the failedInstanceCount value.
     */
    public Integer failedInstanceCount() {
        return this.failedInstanceCount;
    }

    /**
     * Get the inProgressInstanceCount property: The number of instances that are currently being upgraded.
     *
     * @return the inProgressInstanceCount value.
     */
    public Integer inProgressInstanceCount() {
        return this.inProgressInstanceCount;
    }

    /**
     * Get the pendingInstanceCount property: The number of instances that have not yet begun to be upgraded.
     *
     * @return the pendingInstanceCount value.
     */
    public Integer pendingInstanceCount() {
        return this.pendingInstanceCount;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
