// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Used for establishing the purchase context of any 3rd Party artifact through MarketPlace. */
@Fluent
public final class PurchasePlanAutoGenerated {
    /*
     * The plan ID.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The publisher ID.
     */
    @JsonProperty(value = "publisher", required = true)
    private String publisher;

    /*
     * Specifies the product of the image from the marketplace. This is the same value as Offer under the
     * imageReference element.
     */
    @JsonProperty(value = "product", required = true)
    private String product;

    /*
     * The Offer Promotion Code.
     */
    @JsonProperty(value = "promotionCode")
    private String promotionCode;

    /**
     * Get the name property: The plan ID.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The plan ID.
     *
     * @param name the name value to set.
     * @return the PurchasePlanAutoGenerated object itself.
     */
    public PurchasePlanAutoGenerated withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the publisher property: The publisher ID.
     *
     * @return the publisher value.
     */
    public String publisher() {
        return this.publisher;
    }

    /**
     * Set the publisher property: The publisher ID.
     *
     * @param publisher the publisher value to set.
     * @return the PurchasePlanAutoGenerated object itself.
     */
    public PurchasePlanAutoGenerated withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    /**
     * Get the product property: Specifies the product of the image from the marketplace. This is the same value as
     * Offer under the imageReference element.
     *
     * @return the product value.
     */
    public String product() {
        return this.product;
    }

    /**
     * Set the product property: Specifies the product of the image from the marketplace. This is the same value as
     * Offer under the imageReference element.
     *
     * @param product the product value to set.
     * @return the PurchasePlanAutoGenerated object itself.
     */
    public PurchasePlanAutoGenerated withProduct(String product) {
        this.product = product;
        return this;
    }

    /**
     * Get the promotionCode property: The Offer Promotion Code.
     *
     * @return the promotionCode value.
     */
    public String promotionCode() {
        return this.promotionCode;
    }

    /**
     * Set the promotionCode property: The Offer Promotion Code.
     *
     * @param promotionCode the promotionCode value to set.
     * @return the PurchasePlanAutoGenerated object itself.
     */
    public PurchasePlanAutoGenerated withPromotionCode(String promotionCode) {
        this.promotionCode = promotionCode;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property name in model PurchasePlanAutoGenerated"));
        }
        if (publisher() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property publisher in model PurchasePlanAutoGenerated"));
        }
        if (product() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property product in model PurchasePlanAutoGenerated"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PurchasePlanAutoGenerated.class);
}
