// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.DedicatedHostGroupInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The List Dedicated Host Group with resource group response. */
@Fluent
public final class DedicatedHostGroupListResult {
    /*
     * The list of dedicated host groups
     */
    @JsonProperty(value = "value", required = true)
    private List<DedicatedHostGroupInner> value;

    /*
     * The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with this URI to fetch the next page of
     * Dedicated Host Groups.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: The list of dedicated host groups.
     *
     * @return the value value.
     */
    public List<DedicatedHostGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of dedicated host groups.
     *
     * @param value the value value to set.
     * @return the DedicatedHostGroupListResult object itself.
     */
    public DedicatedHostGroupListResult withValue(List<DedicatedHostGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with this URI
     * to fetch the next page of Dedicated Host Groups.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with this URI
     * to fetch the next page of Dedicated Host Groups.
     *
     * @param nextLink the nextLink value to set.
     * @return the DedicatedHostGroupListResult object itself.
     */
    public DedicatedHostGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property value in model DedicatedHostGroupListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DedicatedHostGroupListResult.class);
}
