// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes the role properties. */
@Fluent
public final class CloudServiceRoleProfileProperties {
    /*
     * Resource name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Describes the cloud service role sku.
     */
    @JsonProperty(value = "sku")
    private CloudServiceRoleSku sku;

    /**
     * Get the name property: Resource name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Resource name.
     *
     * @param name the name value to set.
     * @return the CloudServiceRoleProfileProperties object itself.
     */
    public CloudServiceRoleProfileProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the sku property: Describes the cloud service role sku.
     *
     * @return the sku value.
     */
    public CloudServiceRoleSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: Describes the cloud service role sku.
     *
     * @param sku the sku value to set.
     * @return the CloudServiceRoleProfileProperties object itself.
     */
    public CloudServiceRoleProfileProperties withSku(CloudServiceRoleSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
    }
}
