// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes the properties of a Run Command metadata. */
@Fluent
public class RunCommandDocumentBaseInner {
    /*
     * The VM run command schema.
     */
    @JsonProperty(value = "$schema", required = true)
    private String schema;

    /*
     * The VM run command id.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * The Operating System type.
     */
    @JsonProperty(value = "osType", required = true)
    private OperatingSystemTypes osType;

    /*
     * The VM run command label.
     */
    @JsonProperty(value = "label", required = true)
    private String label;

    /*
     * The VM run command description.
     */
    @JsonProperty(value = "description", required = true)
    private String description;

    /**
     * Get the schema property: The VM run command schema.
     *
     * @return the schema value.
     */
    public String schema() {
        return this.schema;
    }

    /**
     * Set the schema property: The VM run command schema.
     *
     * @param schema the schema value to set.
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Get the id property: The VM run command id.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The VM run command id.
     *
     * @param id the id value to set.
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the osType property: The Operating System type.
     *
     * @return the osType value.
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Set the osType property: The Operating System type.
     *
     * @param osType the osType value to set.
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the label property: The VM run command label.
     *
     * @return the label value.
     */
    public String label() {
        return this.label;
    }

    /**
     * Set the label property: The VM run command label.
     *
     * @param label the label value to set.
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the description property: The VM run command description.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The VM run command description.
     *
     * @param description the description value to set.
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (schema() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property schema in model RunCommandDocumentBaseInner"));
        }
        if (id() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property id in model RunCommandDocumentBaseInner"));
        }
        if (osType() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property osType in model RunCommandDocumentBaseInner"));
        }
        if (label() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property label in model RunCommandDocumentBaseInner"));
        }
        if (description() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property description in model RunCommandDocumentBaseInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RunCommandDocumentBaseInner.class);
}
