// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.ConsistencyModeTypes;
import com.azure.resourcemanager.compute.models.RestorePointInstanceView;
import com.azure.resourcemanager.compute.models.RestorePointSourceMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Restore Point details. */
@Fluent
public final class RestorePointInner extends ProxyResource {
    /*
     * The restore point properties.
     */
    @JsonProperty(value = "properties")
    private RestorePointProperties innerProperties;

    /**
     * Get the innerProperties property: The restore point properties.
     *
     * @return the innerProperties value.
     */
    private RestorePointProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the excludeDisks property: List of disk resource ids that the customer wishes to exclude from the restore
     * point. If no disks are specified, all disks will be included.
     *
     * @return the excludeDisks value.
     */
    public List<ApiEntityReference> excludeDisks() {
        return this.innerProperties() == null ? null : this.innerProperties().excludeDisks();
    }

    /**
     * Set the excludeDisks property: List of disk resource ids that the customer wishes to exclude from the restore
     * point. If no disks are specified, all disks will be included.
     *
     * @param excludeDisks the excludeDisks value to set.
     * @return the RestorePointInner object itself.
     */
    public RestorePointInner withExcludeDisks(List<ApiEntityReference> excludeDisks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withExcludeDisks(excludeDisks);
        return this;
    }

    /**
     * Get the sourceMetadata property: Gets the details of the VM captured at the time of the restore point creation.
     *
     * @return the sourceMetadata value.
     */
    public RestorePointSourceMetadata sourceMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceMetadata();
    }

    /**
     * Get the provisioningState property: Gets the provisioning state of the restore point.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the consistencyMode property: ConsistencyMode of the RestorePoint. Can be specified in the input while
     * creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to
     * https://aka.ms/RestorePoints for more details.
     *
     * @return the consistencyMode value.
     */
    public ConsistencyModeTypes consistencyMode() {
        return this.innerProperties() == null ? null : this.innerProperties().consistencyMode();
    }

    /**
     * Set the consistencyMode property: ConsistencyMode of the RestorePoint. Can be specified in the input while
     * creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to
     * https://aka.ms/RestorePoints for more details.
     *
     * @param consistencyMode the consistencyMode value to set.
     * @return the RestorePointInner object itself.
     */
    public RestorePointInner withConsistencyMode(ConsistencyModeTypes consistencyMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withConsistencyMode(consistencyMode);
        return this;
    }

    /**
     * Get the timeCreated property: Gets the creation time of the restore point.
     *
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    /**
     * Set the timeCreated property: Gets the creation time of the restore point.
     *
     * @param timeCreated the timeCreated value to set.
     * @return the RestorePointInner object itself.
     */
    public RestorePointInner withTimeCreated(OffsetDateTime timeCreated) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withTimeCreated(timeCreated);
        return this;
    }

    /**
     * Get the sourceRestorePoint property: Resource Id of the source restore point from which a copy needs to be
     * created.
     *
     * @return the sourceRestorePoint value.
     */
    public ApiEntityReference sourceRestorePoint() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceRestorePoint();
    }

    /**
     * Set the sourceRestorePoint property: Resource Id of the source restore point from which a copy needs to be
     * created.
     *
     * @param sourceRestorePoint the sourceRestorePoint value to set.
     * @return the RestorePointInner object itself.
     */
    public RestorePointInner withSourceRestorePoint(ApiEntityReference sourceRestorePoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withSourceRestorePoint(sourceRestorePoint);
        return this;
    }

    /**
     * Get the instanceView property: The restore point instance view.
     *
     * @return the instanceView value.
     */
    public RestorePointInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
