// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.compute.models.CloudServiceRoleProperties;
import com.azure.resourcemanager.compute.models.CloudServiceRoleSku;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes a role of the cloud service. */
@Fluent
public final class CloudServiceRoleInner {
    /*
     * Resource id
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * Resource name
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Resource type
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * Resource location
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * Describes the cloud service role sku.
     */
    @JsonProperty(value = "sku")
    private CloudServiceRoleSku sku;

    /*
     * The cloud service role properties.
     */
    @JsonProperty(value = "properties")
    private CloudServiceRoleProperties properties;

    /**
     * Get the id property: Resource id.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: Resource name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Resource type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the location property: Resource location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the sku property: Describes the cloud service role sku.
     *
     * @return the sku value.
     */
    public CloudServiceRoleSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: Describes the cloud service role sku.
     *
     * @param sku the sku value to set.
     * @return the CloudServiceRoleInner object itself.
     */
    public CloudServiceRoleInner withSku(CloudServiceRoleSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the properties property: The cloud service role properties.
     *
     * @return the properties value.
     */
    public CloudServiceRoleProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The cloud service role properties.
     *
     * @param properties the properties value to set.
     * @return the CloudServiceRoleInner object itself.
     */
    public CloudServiceRoleInner withProperties(CloudServiceRoleProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (properties() != null) {
            properties().validate();
        }
    }
}
