// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.compute.models.CloudServiceProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Describes the cloud service. */
@Fluent
public final class CloudServiceInner extends Resource {
    /*
     * Cloud service properties
     */
    @JsonProperty(value = "properties")
    private CloudServiceProperties properties;

    /*
     * The system meta data relating to this resource.
     */
    @JsonProperty(value = "systemData")
    private SystemData systemData;

    /**
     * Get the properties property: Cloud service properties.
     *
     * @return the properties value.
     */
    public CloudServiceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Cloud service properties.
     *
     * @param properties the properties value to set.
     * @return the CloudServiceInner object itself.
     */
    public CloudServiceInner withProperties(CloudServiceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: The system meta data relating to this resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Set the systemData property: The system meta data relating to this resource.
     *
     * @param systemData the systemData value to set.
     * @return the CloudServiceInner object itself.
     */
    public CloudServiceInner withSystemData(SystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CloudServiceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CloudServiceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
