// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.RestorePointCollectionInner;
import com.azure.resourcemanager.compute.models.RestorePointCollectionExpandOptions;
import com.azure.resourcemanager.compute.models.RestorePointCollectionUpdate;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RestorePointCollectionsClient. */
public interface RestorePointCollectionsClient
    extends InnerSupportsGet<RestorePointCollectionInner>,
        InnerSupportsListing<RestorePointCollectionInner>,
        InnerSupportsDelete<Void> {
    /**
     * The operation to create or update the restore point collection. Please refer to https://aka.ms/RestorePoints for
     * more details. When updating a restore point collection, only tags may be modified.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param parameters Parameters supplied to the Create or Update restore point collection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RestorePointCollectionInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String restorePointCollectionName, RestorePointCollectionInner parameters);

    /**
     * The operation to create or update the restore point collection. Please refer to https://aka.ms/RestorePoints for
     * more details. When updating a restore point collection, only tags may be modified.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param parameters Parameters supplied to the Create or Update restore point collection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RestorePointCollectionInner> createOrUpdateAsync(
        String resourceGroupName, String restorePointCollectionName, RestorePointCollectionInner parameters);

    /**
     * The operation to create or update the restore point collection. Please refer to https://aka.ms/RestorePoints for
     * more details. When updating a restore point collection, only tags may be modified.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param parameters Parameters supplied to the Create or Update restore point collection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RestorePointCollectionInner createOrUpdate(
        String resourceGroupName, String restorePointCollectionName, RestorePointCollectionInner parameters);

    /**
     * The operation to create or update the restore point collection. Please refer to https://aka.ms/RestorePoints for
     * more details. When updating a restore point collection, only tags may be modified.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param parameters Parameters supplied to the Create or Update restore point collection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RestorePointCollectionInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String restorePointCollectionName,
        RestorePointCollectionInner parameters,
        Context context);

    /**
     * The operation to update the restore point collection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param parameters Parameters supplied to the Update restore point collection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RestorePointCollectionInner>> updateWithResponseAsync(
        String resourceGroupName, String restorePointCollectionName, RestorePointCollectionUpdate parameters);

    /**
     * The operation to update the restore point collection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param parameters Parameters supplied to the Update restore point collection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RestorePointCollectionInner> updateAsync(
        String resourceGroupName, String restorePointCollectionName, RestorePointCollectionUpdate parameters);

    /**
     * The operation to update the restore point collection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param parameters Parameters supplied to the Update restore point collection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RestorePointCollectionInner update(
        String resourceGroupName, String restorePointCollectionName, RestorePointCollectionUpdate parameters);

    /**
     * The operation to update the restore point collection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param parameters Parameters supplied to the Update restore point collection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RestorePointCollectionInner> updateWithResponse(
        String resourceGroupName,
        String restorePointCollectionName,
        RestorePointCollectionUpdate parameters,
        Context context);

    /**
     * The operation to delete the restore point collection. This operation will also delete all the contained restore
     * points.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String restorePointCollectionName);

    /**
     * The operation to delete the restore point collection. This operation will also delete all the contained restore
     * points.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String restorePointCollectionName);

    /**
     * The operation to delete the restore point collection. This operation will also delete all the contained restore
     * points.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String restorePointCollectionName);

    /**
     * The operation to delete the restore point collection. This operation will also delete all the contained restore
     * points.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String restorePointCollectionName, Context context);

    /**
     * The operation to delete the restore point collection. This operation will also delete all the contained restore
     * points.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String restorePointCollectionName);

    /**
     * The operation to delete the restore point collection. This operation will also delete all the contained restore
     * points.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String restorePointCollectionName);

    /**
     * The operation to delete the restore point collection. This operation will also delete all the contained restore
     * points.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String restorePointCollectionName, Context context);

    /**
     * The operation to get the restore point collection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param expand The expand expression to apply on the operation. If expand=restorePoints, server will return all
     *     contained restore points in the restorePointCollection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RestorePointCollectionInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String restorePointCollectionName, RestorePointCollectionExpandOptions expand);

    /**
     * The operation to get the restore point collection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param expand The expand expression to apply on the operation. If expand=restorePoints, server will return all
     *     contained restore points in the restorePointCollection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RestorePointCollectionInner> getByResourceGroupAsync(
        String resourceGroupName, String restorePointCollectionName, RestorePointCollectionExpandOptions expand);

    /**
     * The operation to get the restore point collection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RestorePointCollectionInner> getByResourceGroupAsync(
        String resourceGroupName, String restorePointCollectionName);

    /**
     * The operation to get the restore point collection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RestorePointCollectionInner getByResourceGroup(String resourceGroupName, String restorePointCollectionName);

    /**
     * The operation to get the restore point collection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param expand The expand expression to apply on the operation. If expand=restorePoints, server will return all
     *     contained restore points in the restorePointCollection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return create or update Restore Point collection parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RestorePointCollectionInner> getByResourceGroupWithResponse(
        String resourceGroupName,
        String restorePointCollectionName,
        RestorePointCollectionExpandOptions expand,
        Context context);

    /**
     * Gets the list of restore point collections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of restore point collections in a resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RestorePointCollectionInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Gets the list of restore point collections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of restore point collections in a resource group as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RestorePointCollectionInner> listByResourceGroup(String resourceGroupName);

    /**
     * Gets the list of restore point collections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of restore point collections in a resource group as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RestorePointCollectionInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Gets the list of restore point collections in the subscription. Use nextLink property in the response to get the
     * next page of restore point collections. Do this till nextLink is not null to fetch all the restore point
     * collections.
     *
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of restore point collections in the subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RestorePointCollectionInner> listAsync();

    /**
     * Gets the list of restore point collections in the subscription. Use nextLink property in the response to get the
     * next page of restore point collections. Do this till nextLink is not null to fetch all the restore point
     * collections.
     *
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of restore point collections in the subscription as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RestorePointCollectionInner> list();

    /**
     * Gets the list of restore point collections in the subscription. Use nextLink property in the response to get the
     * next page of restore point collections. Do this till nextLink is not null to fetch all the restore point
     * collections.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of restore point collections in the subscription as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RestorePointCollectionInner> list(Context context);
}
