/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.VirtualMachineExtensionImagesClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionImageInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import java.util.List;
import reactor.core.publisher.Mono;

public final class VirtualMachineExtensionImagesClientImpl
implements VirtualMachineExtensionImagesClient {
    private final VirtualMachineExtensionImagesService service;
    private final ComputeManagementClientImpl client;

    VirtualMachineExtensionImagesClientImpl(ComputeManagementClientImpl client) {
        this.service = (VirtualMachineExtensionImagesService)RestProxy.create(VirtualMachineExtensionImagesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualMachineExtensionImageInner>> getWithResponseAsync(String location, String publisherName, String type, String version) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (type == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter type is required and cannot be null."));
        }
        if (version == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter version is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), location, publisherName, type, version, "2021-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualMachineExtensionImageInner>> getWithResponseAsync(String location, String publisherName, String type, String version, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (type == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter type is required and cannot be null."));
        }
        if (version == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter version is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), location, publisherName, type, version, "2021-11-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineExtensionImageInner> getAsync(String location, String publisherName, String type, String version) {
        return this.getWithResponseAsync(location, publisherName, type, version).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((VirtualMachineExtensionImageInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineExtensionImageInner get(String location, String publisherName, String type, String version) {
        return (VirtualMachineExtensionImageInner)((Object)this.getAsync(location, publisherName, type, version).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualMachineExtensionImageInner> getWithResponse(String location, String publisherName, String type, String version, Context context) {
        return (Response)this.getWithResponseAsync(location, publisherName, type, version, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineExtensionImageInner>>> listTypesWithResponseAsync(String location, String publisherName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listTypes(this.client.getEndpoint(), location, publisherName, "2021-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineExtensionImageInner>>> listTypesWithResponseAsync(String location, String publisherName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listTypes(this.client.getEndpoint(), location, publisherName, "2021-11-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineExtensionImageInner>> listTypesAsync(String location, String publisherName) {
        return this.listTypesWithResponseAsync(location, publisherName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<VirtualMachineExtensionImageInner> listTypes(String location, String publisherName) {
        return (List)this.listTypesAsync(location, publisherName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<VirtualMachineExtensionImageInner>> listTypesWithResponse(String location, String publisherName, Context context) {
        return (Response)this.listTypesWithResponseAsync(location, publisherName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineExtensionImageInner>>> listVersionsWithResponseAsync(String location, String publisherName, String type, String filter, Integer top, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (type == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter type is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listVersions(this.client.getEndpoint(), location, publisherName, type, filter, top, orderby, "2021-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineExtensionImageInner>>> listVersionsWithResponseAsync(String location, String publisherName, String type, String filter, Integer top, String orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (type == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter type is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listVersions(this.client.getEndpoint(), location, publisherName, type, filter, top, orderby, "2021-11-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineExtensionImageInner>> listVersionsAsync(String location, String publisherName, String type, String filter, Integer top, String orderby) {
        return this.listVersionsWithResponseAsync(location, publisherName, type, filter, top, orderby).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineExtensionImageInner>> listVersionsAsync(String location, String publisherName, String type) {
        String filter = null;
        Integer top = null;
        String orderby = null;
        return this.listVersionsWithResponseAsync(location, publisherName, type, filter, top, orderby).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<VirtualMachineExtensionImageInner> listVersions(String location, String publisherName, String type) {
        String filter = null;
        Integer top = null;
        String orderby = null;
        return (List)this.listVersionsAsync(location, publisherName, type, filter, top, orderby).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<VirtualMachineExtensionImageInner>> listVersionsWithResponse(String location, String publisherName, String type, String filter, Integer top, String orderby, Context context) {
        return (Response)this.listVersionsWithResponseAsync(location, publisherName, type, filter, top, orderby, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface VirtualMachineExtensionImagesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmextension/types/{type}/versions/{version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<VirtualMachineExtensionImageInner>> get(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="publisherName") String var3, @PathParam(value="type") String var4, @PathParam(value="version") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmextension/types")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<List<VirtualMachineExtensionImageInner>>> listTypes(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="publisherName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmextension/types/{type}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<List<VirtualMachineExtensionImageInner>>> listVersions(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="publisherName") String var3, @PathParam(value="type") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @HeaderParam(value="Accept") String var10, Context var11);
    }
}

