/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.ConsistencyModeTypes;
import com.azure.resourcemanager.compute.models.RestorePointInstanceView;
import com.azure.resourcemanager.compute.models.RestorePointSourceMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class RestorePointProperties {
    @JsonProperty(value="excludeDisks")
    private List<ApiEntityReference> excludeDisks;
    @JsonProperty(value="sourceMetadata", access=JsonProperty.Access.WRITE_ONLY)
    private RestorePointSourceMetadata sourceMetadata;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="consistencyMode", access=JsonProperty.Access.WRITE_ONLY)
    private ConsistencyModeTypes consistencyMode;
    @JsonProperty(value="timeCreated")
    private OffsetDateTime timeCreated;
    @JsonProperty(value="sourceRestorePoint")
    private ApiEntityReference sourceRestorePoint;
    @JsonProperty(value="instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private RestorePointInstanceView instanceView;

    public List<ApiEntityReference> excludeDisks() {
        return this.excludeDisks;
    }

    public RestorePointProperties withExcludeDisks(List<ApiEntityReference> excludeDisks) {
        this.excludeDisks = excludeDisks;
        return this;
    }

    public RestorePointSourceMetadata sourceMetadata() {
        return this.sourceMetadata;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public ConsistencyModeTypes consistencyMode() {
        return this.consistencyMode;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public RestorePointProperties withTimeCreated(OffsetDateTime timeCreated) {
        this.timeCreated = timeCreated;
        return this;
    }

    public ApiEntityReference sourceRestorePoint() {
        return this.sourceRestorePoint;
    }

    public RestorePointProperties withSourceRestorePoint(ApiEntityReference sourceRestorePoint) {
        this.sourceRestorePoint = sourceRestorePoint;
        return this;
    }

    public RestorePointInstanceView instanceView() {
        return this.instanceView;
    }

    public void validate() {
        if (this.excludeDisks() != null) {
            this.excludeDisks().forEach(e -> e.validate());
        }
        if (this.sourceMetadata() != null) {
            this.sourceMetadata().validate();
        }
        if (this.sourceRestorePoint() != null) {
            this.sourceRestorePoint().validate();
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

