/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ProfileScrubbingRules;
import com.azure.resourcemanager.cdn.models.ProfileScrubbingState;
import java.io.IOException;
import java.util.List;

public final class ProfileLogScrubbing
implements JsonSerializable<ProfileLogScrubbing> {
    private ProfileScrubbingState state;
    private List<ProfileScrubbingRules> scrubbingRules;

    public ProfileScrubbingState state() {
        return this.state;
    }

    public ProfileLogScrubbing withState(ProfileScrubbingState state) {
        this.state = state;
        return this;
    }

    public List<ProfileScrubbingRules> scrubbingRules() {
        return this.scrubbingRules;
    }

    public ProfileLogScrubbing withScrubbingRules(List<ProfileScrubbingRules> scrubbingRules) {
        this.scrubbingRules = scrubbingRules;
        return this;
    }

    public void validate() {
        if (this.scrubbingRules() != null) {
            this.scrubbingRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("scrubbingRules", this.scrubbingRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ProfileLogScrubbing fromJson(JsonReader jsonReader) throws IOException {
        return (ProfileLogScrubbing)jsonReader.readObject(reader -> {
            ProfileLogScrubbing deserializedProfileLogScrubbing = new ProfileLogScrubbing();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedProfileLogScrubbing.state = ProfileScrubbingState.fromString(reader.getString());
                    continue;
                }
                if ("scrubbingRules".equals(fieldName)) {
                    List scrubbingRules;
                    deserializedProfileLogScrubbing.scrubbingRules = scrubbingRules = reader.readArray(reader1 -> ProfileScrubbingRules.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProfileLogScrubbing;
        });
    }
}

