/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.OriginGroupUpdatePropertiesParameters;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.ResponseBasedOriginErrorDetectionParameters;
import java.io.IOException;
import java.util.List;

public final class OriginGroupUpdateParameters
implements JsonSerializable<OriginGroupUpdateParameters> {
    private OriginGroupUpdatePropertiesParameters innerProperties;

    private OriginGroupUpdatePropertiesParameters innerProperties() {
        return this.innerProperties;
    }

    public HealthProbeParameters healthProbeSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().healthProbeSettings();
    }

    public OriginGroupUpdateParameters withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OriginGroupUpdatePropertiesParameters();
        }
        this.innerProperties().withHealthProbeSettings(healthProbeSettings);
        return this;
    }

    public List<ResourceReference> origins() {
        return this.innerProperties() == null ? null : this.innerProperties().origins();
    }

    public OriginGroupUpdateParameters withOrigins(List<ResourceReference> origins) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OriginGroupUpdatePropertiesParameters();
        }
        this.innerProperties().withOrigins(origins);
        return this;
    }

    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().trafficRestorationTimeToHealedOrNewEndpointsInMinutes();
    }

    public OriginGroupUpdateParameters withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OriginGroupUpdatePropertiesParameters();
        }
        this.innerProperties().withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(trafficRestorationTimeToHealedOrNewEndpointsInMinutes);
        return this;
    }

    public ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().responseBasedOriginErrorDetectionSettings();
    }

    public OriginGroupUpdateParameters withResponseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OriginGroupUpdatePropertiesParameters();
        }
        this.innerProperties().withResponseBasedOriginErrorDetectionSettings(responseBasedOriginErrorDetectionSettings);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static OriginGroupUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (OriginGroupUpdateParameters)jsonReader.readObject(reader -> {
            OriginGroupUpdateParameters deserializedOriginGroupUpdateParameters = new OriginGroupUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedOriginGroupUpdateParameters.innerProperties = OriginGroupUpdatePropertiesParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOriginGroupUpdateParameters;
        });
    }
}

