// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The WafRankingsResponseDataItemMetric model.
 */
@Fluent
public final class WafRankingsResponseDataItemMetric implements JsonSerializable<WafRankingsResponseDataItemMetric> {
    /*
     * The metric property.
     */
    private String metric;

    /*
     * The value property.
     */
    private Long value;

    /*
     * The percentage property.
     */
    private Double percentage;

    /**
     * Creates an instance of WafRankingsResponseDataItemMetric class.
     */
    public WafRankingsResponseDataItemMetric() {
    }

    /**
     * Get the metric property: The metric property.
     * 
     * @return the metric value.
     */
    public String metric() {
        return this.metric;
    }

    /**
     * Set the metric property: The metric property.
     * 
     * @param metric the metric value to set.
     * @return the WafRankingsResponseDataItemMetric object itself.
     */
    public WafRankingsResponseDataItemMetric withMetric(String metric) {
        this.metric = metric;
        return this;
    }

    /**
     * Get the value property: The value property.
     * 
     * @return the value value.
     */
    public Long value() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     * 
     * @param value the value value to set.
     * @return the WafRankingsResponseDataItemMetric object itself.
     */
    public WafRankingsResponseDataItemMetric withValue(Long value) {
        this.value = value;
        return this;
    }

    /**
     * Get the percentage property: The percentage property.
     * 
     * @return the percentage value.
     */
    public Double percentage() {
        return this.percentage;
    }

    /**
     * Set the percentage property: The percentage property.
     * 
     * @param percentage the percentage value to set.
     * @return the WafRankingsResponseDataItemMetric object itself.
     */
    public WafRankingsResponseDataItemMetric withPercentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("metric", this.metric);
        jsonWriter.writeNumberField("value", this.value);
        jsonWriter.writeNumberField("percentage", this.percentage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WafRankingsResponseDataItemMetric from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WafRankingsResponseDataItemMetric if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WafRankingsResponseDataItemMetric.
     */
    public static WafRankingsResponseDataItemMetric fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WafRankingsResponseDataItemMetric deserializedWafRankingsResponseDataItemMetric
                = new WafRankingsResponseDataItemMetric();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metric".equals(fieldName)) {
                    deserializedWafRankingsResponseDataItemMetric.metric = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedWafRankingsResponseDataItemMetric.value = reader.getNullable(JsonReader::getLong);
                } else if ("percentage".equals(fieldName)) {
                    deserializedWafRankingsResponseDataItemMetric.percentage
                        = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWafRankingsResponseDataItemMetric;
        });
    }
}
