// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Input of the custom domain to be validated for DNS mapping.
 */
@Fluent
public final class ValidateCustomDomainInput implements JsonSerializable<ValidateCustomDomainInput> {
    /*
     * The host name of the custom domain. Must be a domain name.
     */
    private String hostname;

    /**
     * Creates an instance of ValidateCustomDomainInput class.
     */
    public ValidateCustomDomainInput() {
    }

    /**
     * Get the hostname property: The host name of the custom domain. Must be a domain name.
     * 
     * @return the hostname value.
     */
    public String hostname() {
        return this.hostname;
    }

    /**
     * Set the hostname property: The host name of the custom domain. Must be a domain name.
     * 
     * @param hostname the hostname value to set.
     * @return the ValidateCustomDomainInput object itself.
     */
    public ValidateCustomDomainInput withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (hostname() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property hostname in model ValidateCustomDomainInput"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ValidateCustomDomainInput.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostName", this.hostname);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ValidateCustomDomainInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ValidateCustomDomainInput if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ValidateCustomDomainInput.
     */
    public static ValidateCustomDomainInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ValidateCustomDomainInput deserializedValidateCustomDomainInput = new ValidateCustomDomainInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("hostName".equals(fieldName)) {
                    deserializedValidateCustomDomainInput.hostname = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedValidateCustomDomainInput;
        });
    }
}
