// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the parameters for the url redirect action.
 */
@Fluent
public final class UrlRedirectActionParameters implements JsonSerializable<UrlRedirectActionParameters> {
    /*
     * The typeName property.
     */
    private String typeName = "DeliveryRuleUrlRedirectActionParameters";

    /*
     * The redirect type the rule will use when redirecting traffic.
     */
    private RedirectType redirectType;

    /*
     * Protocol to use for the redirect. The default value is MatchRequest
     */
    private DestinationProtocol destinationProtocol;

    /*
     * The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as
     * destination path.
     */
    private String customPath;

    /*
     * Host to redirect. Leave empty to use the incoming host as the destination host.
     */
    private String customHostname;

    /*
     * The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query
     * string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and &
     * will be added automatically so do not include them.
     */
    private String customQueryString;

    /*
     * Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
     */
    private String customFragment;

    /**
     * Creates an instance of UrlRedirectActionParameters class.
     */
    public UrlRedirectActionParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the UrlRedirectActionParameters object itself.
     */
    public UrlRedirectActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the redirectType property: The redirect type the rule will use when redirecting traffic.
     * 
     * @return the redirectType value.
     */
    public RedirectType redirectType() {
        return this.redirectType;
    }

    /**
     * Set the redirectType property: The redirect type the rule will use when redirecting traffic.
     * 
     * @param redirectType the redirectType value to set.
     * @return the UrlRedirectActionParameters object itself.
     */
    public UrlRedirectActionParameters withRedirectType(RedirectType redirectType) {
        this.redirectType = redirectType;
        return this;
    }

    /**
     * Get the destinationProtocol property: Protocol to use for the redirect. The default value is MatchRequest.
     * 
     * @return the destinationProtocol value.
     */
    public DestinationProtocol destinationProtocol() {
        return this.destinationProtocol;
    }

    /**
     * Set the destinationProtocol property: Protocol to use for the redirect. The default value is MatchRequest.
     * 
     * @param destinationProtocol the destinationProtocol value to set.
     * @return the UrlRedirectActionParameters object itself.
     */
    public UrlRedirectActionParameters withDestinationProtocol(DestinationProtocol destinationProtocol) {
        this.destinationProtocol = destinationProtocol;
        return this;
    }

    /**
     * Get the customPath property: The full path to redirect. Path cannot be empty and must start with /. Leave empty
     * to use the incoming path as destination path.
     * 
     * @return the customPath value.
     */
    public String customPath() {
        return this.customPath;
    }

    /**
     * Set the customPath property: The full path to redirect. Path cannot be empty and must start with /. Leave empty
     * to use the incoming path as destination path.
     * 
     * @param customPath the customPath value to set.
     * @return the UrlRedirectActionParameters object itself.
     */
    public UrlRedirectActionParameters withCustomPath(String customPath) {
        this.customPath = customPath;
        return this;
    }

    /**
     * Get the customHostname property: Host to redirect. Leave empty to use the incoming host as the destination host.
     * 
     * @return the customHostname value.
     */
    public String customHostname() {
        return this.customHostname;
    }

    /**
     * Set the customHostname property: Host to redirect. Leave empty to use the incoming host as the destination host.
     * 
     * @param customHostname the customHostname value to set.
     * @return the UrlRedirectActionParameters object itself.
     */
    public UrlRedirectActionParameters withCustomHostname(String customHostname) {
        this.customHostname = customHostname;
        return this;
    }

    /**
     * Get the customQueryString property: The set of query strings to be placed in the redirect URL. Setting this value
     * would replace any existing query string; leave empty to preserve the incoming query string. Query string must be
     * in &lt;key&gt;=&lt;value&gt; format. ? and &amp; will be added automatically so do not include them.
     * 
     * @return the customQueryString value.
     */
    public String customQueryString() {
        return this.customQueryString;
    }

    /**
     * Set the customQueryString property: The set of query strings to be placed in the redirect URL. Setting this value
     * would replace any existing query string; leave empty to preserve the incoming query string. Query string must be
     * in &lt;key&gt;=&lt;value&gt; format. ? and &amp; will be added automatically so do not include them.
     * 
     * @param customQueryString the customQueryString value to set.
     * @return the UrlRedirectActionParameters object itself.
     */
    public UrlRedirectActionParameters withCustomQueryString(String customQueryString) {
        this.customQueryString = customQueryString;
        return this;
    }

    /**
     * Get the customFragment property: Fragment to add to the redirect URL. Fragment is the part of the URL that comes
     * after #. Do not include the #.
     * 
     * @return the customFragment value.
     */
    public String customFragment() {
        return this.customFragment;
    }

    /**
     * Set the customFragment property: Fragment to add to the redirect URL. Fragment is the part of the URL that comes
     * after #. Do not include the #.
     * 
     * @param customFragment the customFragment value to set.
     * @return the UrlRedirectActionParameters object itself.
     */
    public UrlRedirectActionParameters withCustomFragment(String customFragment) {
        this.customFragment = customFragment;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (redirectType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property redirectType in model UrlRedirectActionParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UrlRedirectActionParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("redirectType", this.redirectType == null ? null : this.redirectType.toString());
        jsonWriter.writeStringField("destinationProtocol",
            this.destinationProtocol == null ? null : this.destinationProtocol.toString());
        jsonWriter.writeStringField("customPath", this.customPath);
        jsonWriter.writeStringField("customHostname", this.customHostname);
        jsonWriter.writeStringField("customQueryString", this.customQueryString);
        jsonWriter.writeStringField("customFragment", this.customFragment);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UrlRedirectActionParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UrlRedirectActionParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UrlRedirectActionParameters.
     */
    public static UrlRedirectActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UrlRedirectActionParameters deserializedUrlRedirectActionParameters = new UrlRedirectActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("redirectType".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.redirectType = RedirectType.fromString(reader.getString());
                } else if ("destinationProtocol".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.destinationProtocol
                        = DestinationProtocol.fromString(reader.getString());
                } else if ("customPath".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.customPath = reader.getString();
                } else if ("customHostname".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.customHostname = reader.getString();
                } else if ("customQueryString".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.customQueryString = reader.getString();
                } else if ("customFragment".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.customFragment = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUrlRedirectActionParameters;
        });
    }
}
