// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * settings for security policy patterns to match.
 */
@Fluent
public final class SecurityPolicyWebApplicationFirewallAssociation
    implements JsonSerializable<SecurityPolicyWebApplicationFirewallAssociation> {
    /*
     * List of domains.
     */
    private List<ActivatedResourceReference> domains;

    /*
     * List of paths
     */
    private List<String> patternsToMatch;

    /**
     * Creates an instance of SecurityPolicyWebApplicationFirewallAssociation class.
     */
    public SecurityPolicyWebApplicationFirewallAssociation() {
    }

    /**
     * Get the domains property: List of domains.
     * 
     * @return the domains value.
     */
    public List<ActivatedResourceReference> domains() {
        return this.domains;
    }

    /**
     * Set the domains property: List of domains.
     * 
     * @param domains the domains value to set.
     * @return the SecurityPolicyWebApplicationFirewallAssociation object itself.
     */
    public SecurityPolicyWebApplicationFirewallAssociation withDomains(List<ActivatedResourceReference> domains) {
        this.domains = domains;
        return this;
    }

    /**
     * Get the patternsToMatch property: List of paths.
     * 
     * @return the patternsToMatch value.
     */
    public List<String> patternsToMatch() {
        return this.patternsToMatch;
    }

    /**
     * Set the patternsToMatch property: List of paths.
     * 
     * @param patternsToMatch the patternsToMatch value to set.
     * @return the SecurityPolicyWebApplicationFirewallAssociation object itself.
     */
    public SecurityPolicyWebApplicationFirewallAssociation withPatternsToMatch(List<String> patternsToMatch) {
        this.patternsToMatch = patternsToMatch;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (domains() != null) {
            domains().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("domains", this.domains, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("patternsToMatch", this.patternsToMatch,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityPolicyWebApplicationFirewallAssociation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityPolicyWebApplicationFirewallAssociation if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityPolicyWebApplicationFirewallAssociation.
     */
    public static SecurityPolicyWebApplicationFirewallAssociation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityPolicyWebApplicationFirewallAssociation deserializedSecurityPolicyWebApplicationFirewallAssociation
                = new SecurityPolicyWebApplicationFirewallAssociation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("domains".equals(fieldName)) {
                    List<ActivatedResourceReference> domains
                        = reader.readArray(reader1 -> ActivatedResourceReference.fromJson(reader1));
                    deserializedSecurityPolicyWebApplicationFirewallAssociation.domains = domains;
                } else if ("patternsToMatch".equals(fieldName)) {
                    List<String> patternsToMatch = reader.readArray(reader1 -> reader1.getString());
                    deserializedSecurityPolicyWebApplicationFirewallAssociation.patternsToMatch = patternsToMatch;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityPolicyWebApplicationFirewallAssociation;
        });
    }
}
