// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * CIDR Ip address.
 */
@Fluent
public final class CidrIpAddress implements JsonSerializable<CidrIpAddress> {
    /*
     * Ip address itself.
     */
    private String baseIpAddress;

    /*
     * The length of the prefix of the ip address.
     */
    private Integer prefixLength;

    /**
     * Creates an instance of CidrIpAddress class.
     */
    public CidrIpAddress() {
    }

    /**
     * Get the baseIpAddress property: Ip address itself.
     * 
     * @return the baseIpAddress value.
     */
    public String baseIpAddress() {
        return this.baseIpAddress;
    }

    /**
     * Set the baseIpAddress property: Ip address itself.
     * 
     * @param baseIpAddress the baseIpAddress value to set.
     * @return the CidrIpAddress object itself.
     */
    public CidrIpAddress withBaseIpAddress(String baseIpAddress) {
        this.baseIpAddress = baseIpAddress;
        return this;
    }

    /**
     * Get the prefixLength property: The length of the prefix of the ip address.
     * 
     * @return the prefixLength value.
     */
    public Integer prefixLength() {
        return this.prefixLength;
    }

    /**
     * Set the prefixLength property: The length of the prefix of the ip address.
     * 
     * @param prefixLength the prefixLength value to set.
     * @return the CidrIpAddress object itself.
     */
    public CidrIpAddress withPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("baseIpAddress", this.baseIpAddress);
        jsonWriter.writeNumberField("prefixLength", this.prefixLength);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CidrIpAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CidrIpAddress if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CidrIpAddress.
     */
    public static CidrIpAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CidrIpAddress deserializedCidrIpAddress = new CidrIpAddress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("baseIpAddress".equals(fieldName)) {
                    deserializedCidrIpAddress.baseIpAddress = reader.getString();
                } else if ("prefixLength".equals(fieldName)) {
                    deserializedCidrIpAddress.prefixLength = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCidrIpAddress;
        });
    }
}
