// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure FirstParty Managed Certificate provided by other first party resource providers to enable HTTPS.
 */
@Fluent
public final class AzureFirstPartyManagedCertificate extends Certificate {
    /*
     * Certificate expiration date.
     */
    private String expirationDate;

    /*
     * Subject name in the certificate.
     */
    private String subject;

    /**
     * Creates an instance of AzureFirstPartyManagedCertificate class.
     */
    public AzureFirstPartyManagedCertificate() {
    }

    /**
     * Get the expirationDate property: Certificate expiration date.
     * 
     * @return the expirationDate value.
     */
    @Override
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Get the subject property: Subject name in the certificate.
     * 
     * @return the subject value.
     */
    @Override
    public String subject() {
        return this.subject;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureFirstPartyManagedCertificate withType(SecretType type) {
        super.withType(type);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", type() == null ? null : type().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirstPartyManagedCertificate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirstPartyManagedCertificate if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirstPartyManagedCertificate.
     */
    public static AzureFirstPartyManagedCertificate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirstPartyManagedCertificate deserializedAzureFirstPartyManagedCertificate
                = new AzureFirstPartyManagedCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificate.withType(SecretType.fromString(reader.getString()));
                } else if ("subject".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificate.subject = reader.getString();
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificate.expirationDate = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirstPartyManagedCertificate;
        });
    }
}
