// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.AfdEndpointInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list endpoints. It contains a list of endpoint objects and a URL link to get the next set of
 * results.
 */
@Fluent
public final class AfdEndpointListResult implements JsonSerializable<AfdEndpointListResult> {
    /*
     * List of AzureFrontDoor endpoints within a profile
     */
    private List<AfdEndpointInner> value;

    /*
     * URL to get the next set of endpoint objects if there is any.
     */
    private String nextLink;

    /**
     * Creates an instance of AfdEndpointListResult class.
     */
    public AfdEndpointListResult() {
    }

    /**
     * Get the value property: List of AzureFrontDoor endpoints within a profile.
     * 
     * @return the value value.
     */
    public List<AfdEndpointInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: URL to get the next set of endpoint objects if there is any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of endpoint objects if there is any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the AfdEndpointListResult object itself.
     */
    public AfdEndpointListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AfdEndpointListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AfdEndpointListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AfdEndpointListResult.
     */
    public static AfdEndpointListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AfdEndpointListResult deserializedAfdEndpointListResult = new AfdEndpointListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AfdEndpointInner> value = reader.readArray(reader1 -> AfdEndpointInner.fromJson(reader1));
                    deserializedAfdEndpointListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedAfdEndpointListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAfdEndpointListResult;
        });
    }
}
