// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.MatchProcessingBehavior;
import java.io.IOException;
import java.util.List;

/**
 * The JSON object that contains the properties of the Rules to create.
 */
@Fluent
public final class RuleProperties extends RuleUpdatePropertiesParameters {
    /*
     * Provisioning status
     */
    private AfdProvisioningState provisioningState;

    /*
     * The deploymentStatus property.
     */
    private DeploymentStatus deploymentStatus;

    /*
     * The name of the rule set containing the rule.
     */
    private String ruleSetName;

    /**
     * Creates an instance of RuleProperties class.
     */
    public RuleProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning status.
     * 
     * @return the provisioningState value.
     */
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the deploymentStatus property: The deploymentStatus property.
     * 
     * @return the deploymentStatus value.
     */
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    /**
     * Get the ruleSetName property: The name of the rule set containing the rule.
     * 
     * @return the ruleSetName value.
     */
    @Override
    public String ruleSetName() {
        return this.ruleSetName;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RuleProperties withOrder(Integer order) {
        super.withOrder(order);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RuleProperties withConditions(List<DeliveryRuleCondition> conditions) {
        super.withConditions(conditions);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RuleProperties withActions(List<DeliveryRuleAction> actions) {
        super.withActions(actions);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RuleProperties withMatchProcessingBehavior(MatchProcessingBehavior matchProcessingBehavior) {
        super.withMatchProcessingBehavior(matchProcessingBehavior);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("order", order());
        jsonWriter.writeArrayField("conditions", conditions(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("actions", actions(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("matchProcessingBehavior",
            matchProcessingBehavior() == null ? null : matchProcessingBehavior().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RuleProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RuleProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RuleProperties.
     */
    public static RuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RuleProperties deserializedRuleProperties = new RuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ruleSetName".equals(fieldName)) {
                    deserializedRuleProperties.ruleSetName = reader.getString();
                } else if ("order".equals(fieldName)) {
                    deserializedRuleProperties.withOrder(reader.getNullable(JsonReader::getInt));
                } else if ("conditions".equals(fieldName)) {
                    List<DeliveryRuleCondition> conditions
                        = reader.readArray(reader1 -> DeliveryRuleCondition.fromJson(reader1));
                    deserializedRuleProperties.withConditions(conditions);
                } else if ("actions".equals(fieldName)) {
                    List<DeliveryRuleAction> actions
                        = reader.readArray(reader1 -> DeliveryRuleAction.fromJson(reader1));
                    deserializedRuleProperties.withActions(actions);
                } else if ("matchProcessingBehavior".equals(fieldName)) {
                    deserializedRuleProperties
                        .withMatchProcessingBehavior(MatchProcessingBehavior.fromString(reader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRuleProperties.provisioningState = AfdProvisioningState.fromString(reader.getString());
                } else if ("deploymentStatus".equals(fieldName)) {
                    deserializedRuleProperties.deploymentStatus = DeploymentStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRuleProperties;
        });
    }
}
