// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the parameters for the url rewrite action.
 */
@Fluent
public final class UrlRewriteActionParameters implements JsonSerializable<UrlRewriteActionParameters> {
    /*
     * The typeName property.
     */
    private String typeName = "DeliveryRuleUrlRewriteActionParameters";

    /*
     * define a request URI pattern that identifies the type of requests that may be rewritten. If value is blank, all
     * strings are matched.
     */
    private String sourcePattern;

    /*
     * Define the relative URL to which the above requests will be rewritten by.
     */
    private String destination;

    /*
     * Whether to preserve unmatched path. Default value is true.
     */
    private Boolean preserveUnmatchedPath;

    /**
     * Creates an instance of UrlRewriteActionParameters class.
     */
    public UrlRewriteActionParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the UrlRewriteActionParameters object itself.
     */
    public UrlRewriteActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the sourcePattern property: define a request URI pattern that identifies the type of requests that may be
     * rewritten. If value is blank, all strings are matched.
     * 
     * @return the sourcePattern value.
     */
    public String sourcePattern() {
        return this.sourcePattern;
    }

    /**
     * Set the sourcePattern property: define a request URI pattern that identifies the type of requests that may be
     * rewritten. If value is blank, all strings are matched.
     * 
     * @param sourcePattern the sourcePattern value to set.
     * @return the UrlRewriteActionParameters object itself.
     */
    public UrlRewriteActionParameters withSourcePattern(String sourcePattern) {
        this.sourcePattern = sourcePattern;
        return this;
    }

    /**
     * Get the destination property: Define the relative URL to which the above requests will be rewritten by.
     * 
     * @return the destination value.
     */
    public String destination() {
        return this.destination;
    }

    /**
     * Set the destination property: Define the relative URL to which the above requests will be rewritten by.
     * 
     * @param destination the destination value to set.
     * @return the UrlRewriteActionParameters object itself.
     */
    public UrlRewriteActionParameters withDestination(String destination) {
        this.destination = destination;
        return this;
    }

    /**
     * Get the preserveUnmatchedPath property: Whether to preserve unmatched path. Default value is true.
     * 
     * @return the preserveUnmatchedPath value.
     */
    public Boolean preserveUnmatchedPath() {
        return this.preserveUnmatchedPath;
    }

    /**
     * Set the preserveUnmatchedPath property: Whether to preserve unmatched path. Default value is true.
     * 
     * @param preserveUnmatchedPath the preserveUnmatchedPath value to set.
     * @return the UrlRewriteActionParameters object itself.
     */
    public UrlRewriteActionParameters withPreserveUnmatchedPath(Boolean preserveUnmatchedPath) {
        this.preserveUnmatchedPath = preserveUnmatchedPath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourcePattern() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourcePattern in model UrlRewriteActionParameters"));
        }
        if (destination() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destination in model UrlRewriteActionParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UrlRewriteActionParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("sourcePattern", this.sourcePattern);
        jsonWriter.writeStringField("destination", this.destination);
        jsonWriter.writeBooleanField("preserveUnmatchedPath", this.preserveUnmatchedPath);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UrlRewriteActionParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UrlRewriteActionParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UrlRewriteActionParameters.
     */
    public static UrlRewriteActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UrlRewriteActionParameters deserializedUrlRewriteActionParameters = new UrlRewriteActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourcePattern".equals(fieldName)) {
                    deserializedUrlRewriteActionParameters.sourcePattern = reader.getString();
                } else if ("destination".equals(fieldName)) {
                    deserializedUrlRewriteActionParameters.destination = reader.getString();
                } else if ("preserveUnmatchedPath".equals(fieldName)) {
                    deserializedUrlRewriteActionParameters.preserveUnmatchedPath
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUrlRewriteActionParameters;
        });
    }
}
