// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.ResourceUsageInner;
import java.io.IOException;
import java.util.List;

/**
 * Output of check resource usage API.
 */
@Fluent
public final class ResourceUsageListResult implements JsonSerializable<ResourceUsageListResult> {
    /*
     * List of resource usages.
     */
    private List<ResourceUsageInner> value;

    /*
     * URL to get the next set of custom domain objects if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of ResourceUsageListResult class.
     */
    public ResourceUsageListResult() {
    }

    /**
     * Get the value property: List of resource usages.
     * 
     * @return the value value.
     */
    public List<ResourceUsageInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: URL to get the next set of custom domain objects if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of custom domain objects if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ResourceUsageListResult object itself.
     */
    public ResourceUsageListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceUsageListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceUsageListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceUsageListResult.
     */
    public static ResourceUsageListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceUsageListResult deserializedResourceUsageListResult = new ResourceUsageListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ResourceUsageInner> value = reader.readArray(reader1 -> ResourceUsageInner.fromJson(reader1));
                    deserializedResourceUsageListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedResourceUsageListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceUsageListResult;
        });
    }
}
