// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Defines the parameters for RequestHeader match conditions.
 */
@Fluent
public final class RequestHeaderMatchConditionParameters
    implements JsonSerializable<RequestHeaderMatchConditionParameters> {
    /*
     * The typeName property.
     */
    private String typeName = "DeliveryRuleRequestHeaderConditionParameters";

    /*
     * Name of Header to be matched
     */
    private String selector;

    /*
     * Describes operator to be matched
     */
    private RequestHeaderOperator operator;

    /*
     * Describes if this is negate condition or not
     */
    private Boolean negateCondition;

    /*
     * The match value for the condition of the delivery rule
     */
    private List<String> matchValues;

    /*
     * List of transforms
     */
    private List<Transform> transforms;

    /**
     * Creates an instance of RequestHeaderMatchConditionParameters class.
     */
    public RequestHeaderMatchConditionParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the RequestHeaderMatchConditionParameters object itself.
     */
    public RequestHeaderMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the selector property: Name of Header to be matched.
     * 
     * @return the selector value.
     */
    public String selector() {
        return this.selector;
    }

    /**
     * Set the selector property: Name of Header to be matched.
     * 
     * @param selector the selector value to set.
     * @return the RequestHeaderMatchConditionParameters object itself.
     */
    public RequestHeaderMatchConditionParameters withSelector(String selector) {
        this.selector = selector;
        return this;
    }

    /**
     * Get the operator property: Describes operator to be matched.
     * 
     * @return the operator value.
     */
    public RequestHeaderOperator operator() {
        return this.operator;
    }

    /**
     * Set the operator property: Describes operator to be matched.
     * 
     * @param operator the operator value to set.
     * @return the RequestHeaderMatchConditionParameters object itself.
     */
    public RequestHeaderMatchConditionParameters withOperator(RequestHeaderOperator operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the negateCondition property: Describes if this is negate condition or not.
     * 
     * @return the negateCondition value.
     */
    public Boolean negateCondition() {
        return this.negateCondition;
    }

    /**
     * Set the negateCondition property: Describes if this is negate condition or not.
     * 
     * @param negateCondition the negateCondition value to set.
     * @return the RequestHeaderMatchConditionParameters object itself.
     */
    public RequestHeaderMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    /**
     * Get the matchValues property: The match value for the condition of the delivery rule.
     * 
     * @return the matchValues value.
     */
    public List<String> matchValues() {
        return this.matchValues;
    }

    /**
     * Set the matchValues property: The match value for the condition of the delivery rule.
     * 
     * @param matchValues the matchValues value to set.
     * @return the RequestHeaderMatchConditionParameters object itself.
     */
    public RequestHeaderMatchConditionParameters withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    /**
     * Get the transforms property: List of transforms.
     * 
     * @return the transforms value.
     */
    public List<Transform> transforms() {
        return this.transforms;
    }

    /**
     * Set the transforms property: List of transforms.
     * 
     * @param transforms the transforms value to set.
     * @return the RequestHeaderMatchConditionParameters object itself.
     */
    public RequestHeaderMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (operator() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property operator in model RequestHeaderMatchConditionParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RequestHeaderMatchConditionParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeStringField("selector", this.selector);
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("transforms", this.transforms,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RequestHeaderMatchConditionParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RequestHeaderMatchConditionParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RequestHeaderMatchConditionParameters.
     */
    public static RequestHeaderMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RequestHeaderMatchConditionParameters deserializedRequestHeaderMatchConditionParameters
                = new RequestHeaderMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operator".equals(fieldName)) {
                    deserializedRequestHeaderMatchConditionParameters.operator
                        = RequestHeaderOperator.fromString(reader.getString());
                } else if ("selector".equals(fieldName)) {
                    deserializedRequestHeaderMatchConditionParameters.selector = reader.getString();
                } else if ("negateCondition".equals(fieldName)) {
                    deserializedRequestHeaderMatchConditionParameters.negateCondition
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("matchValues".equals(fieldName)) {
                    List<String> matchValues = reader.readArray(reader1 -> reader1.getString());
                    deserializedRequestHeaderMatchConditionParameters.matchValues = matchValues;
                } else if ("transforms".equals(fieldName)) {
                    List<Transform> transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    deserializedRequestHeaderMatchConditionParameters.transforms = transforms;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRequestHeaderMatchConditionParameters;
        });
    }
}
