// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the cache-key query string action for the delivery rule.
 */
@Fluent
public final class DeliveryRuleCacheKeyQueryStringAction extends DeliveryRuleAction {
    /*
     * The name of the action for the delivery rule.
     */
    private DeliveryRuleActionValue name = DeliveryRuleActionValue.CACHE_KEY_QUERY_STRING;

    /*
     * Defines the parameters for the action.
     */
    private CacheKeyQueryStringActionParameters parameters;

    /**
     * Creates an instance of DeliveryRuleCacheKeyQueryStringAction class.
     */
    public DeliveryRuleCacheKeyQueryStringAction() {
    }

    /**
     * Get the name property: The name of the action for the delivery rule.
     * 
     * @return the name value.
     */
    @Override
    public DeliveryRuleActionValue name() {
        return this.name;
    }

    /**
     * Get the parameters property: Defines the parameters for the action.
     * 
     * @return the parameters value.
     */
    public CacheKeyQueryStringActionParameters parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Defines the parameters for the action.
     * 
     * @param parameters the parameters value to set.
     * @return the DeliveryRuleCacheKeyQueryStringAction object itself.
     */
    public DeliveryRuleCacheKeyQueryStringAction withParameters(CacheKeyQueryStringActionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (parameters() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property parameters in model DeliveryRuleCacheKeyQueryStringAction"));
        } else {
            parameters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleCacheKeyQueryStringAction.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeliveryRuleCacheKeyQueryStringAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeliveryRuleCacheKeyQueryStringAction if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeliveryRuleCacheKeyQueryStringAction.
     */
    public static DeliveryRuleCacheKeyQueryStringAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeliveryRuleCacheKeyQueryStringAction deserializedDeliveryRuleCacheKeyQueryStringAction
                = new DeliveryRuleCacheKeyQueryStringAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleCacheKeyQueryStringAction.parameters
                        = CacheKeyQueryStringActionParameters.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleCacheKeyQueryStringAction.name
                        = DeliveryRuleActionValue.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeliveryRuleCacheKeyQueryStringAction;
        });
    }
}
