// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Customer Certificate used for https.
 */
@Fluent
public final class CustomerCertificateParameters extends SecretParameters {
    /*
     * The type of the secret resource.
     */
    private SecretType type = SecretType.CUSTOMER_CERTIFICATE;

    /*
     * Resource reference to the Azure Key Vault certificate. Expected to be in format of
     * /subscriptions/{subscriptionId}/resourceGroups/{sourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{certificateName}
     */
    private ResourceReference secretSource;

    /*
     * Version of the secret to be used
     */
    private String secretVersion;

    /*
     * Whether to use the latest version for the certificate
     */
    private Boolean useLatestVersion;

    /*
     * Subject name in the certificate.
     */
    private String subject;

    /*
     * Certificate expiration date.
     */
    private String expirationDate;

    /*
     * Certificate issuing authority.
     */
    private String certificateAuthority;

    /*
     * The list of SANs.
     */
    private List<String> subjectAlternativeNames;

    /*
     * Certificate thumbprint.
     */
    private String thumbprint;

    /**
     * Creates an instance of CustomerCertificateParameters class.
     */
    public CustomerCertificateParameters() {
    }

    /**
     * Get the type property: The type of the secret resource.
     *
     * @return the type value.
     */
    @Override
    public SecretType type() {
        return this.type;
    }

    /**
     * Get the secretSource property: Resource reference to the Azure Key Vault certificate. Expected to be in format of
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{certificateName}.
     *
     * @return the secretSource value.
     */
    public ResourceReference secretSource() {
        return this.secretSource;
    }

    /**
     * Set the secretSource property: Resource reference to the Azure Key Vault certificate. Expected to be in format of
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{certificateName}.
     *
     * @param secretSource the secretSource value to set.
     * @return the CustomerCertificateParameters object itself.
     */
    public CustomerCertificateParameters withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    /**
     * Get the secretVersion property: Version of the secret to be used.
     *
     * @return the secretVersion value.
     */
    public String secretVersion() {
        return this.secretVersion;
    }

    /**
     * Set the secretVersion property: Version of the secret to be used.
     *
     * @param secretVersion the secretVersion value to set.
     * @return the CustomerCertificateParameters object itself.
     */
    public CustomerCertificateParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    /**
     * Get the useLatestVersion property: Whether to use the latest version for the certificate.
     *
     * @return the useLatestVersion value.
     */
    public Boolean useLatestVersion() {
        return this.useLatestVersion;
    }

    /**
     * Set the useLatestVersion property: Whether to use the latest version for the certificate.
     *
     * @param useLatestVersion the useLatestVersion value to set.
     * @return the CustomerCertificateParameters object itself.
     */
    public CustomerCertificateParameters withUseLatestVersion(Boolean useLatestVersion) {
        this.useLatestVersion = useLatestVersion;
        return this;
    }

    /**
     * Get the subject property: Subject name in the certificate.
     *
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Get the expirationDate property: Certificate expiration date.
     *
     * @return the expirationDate value.
     */
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Get the certificateAuthority property: Certificate issuing authority.
     *
     * @return the certificateAuthority value.
     */
    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    /**
     * Get the subjectAlternativeNames property: The list of SANs.
     *
     * @return the subjectAlternativeNames value.
     */
    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    /**
     * Set the subjectAlternativeNames property: The list of SANs.
     *
     * @param subjectAlternativeNames the subjectAlternativeNames value to set.
     * @return the CustomerCertificateParameters object itself.
     */
    public CustomerCertificateParameters withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    /**
     * Get the thumbprint property: Certificate thumbprint.
     *
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (secretSource() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property secretSource in model CustomerCertificateParameters"));
        } else {
            secretSource().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomerCertificateParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("secretSource", this.secretSource);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        jsonWriter.writeBooleanField("useLatestVersion", this.useLatestVersion);
        jsonWriter.writeArrayField("subjectAlternativeNames", this.subjectAlternativeNames,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomerCertificateParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomerCertificateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CustomerCertificateParameters.
     */
    public static CustomerCertificateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomerCertificateParameters deserializedCustomerCertificateParameters
                = new CustomerCertificateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("secretSource".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.secretSource = ResourceReference.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.type = SecretType.fromString(reader.getString());
                } else if ("secretVersion".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.secretVersion = reader.getString();
                } else if ("useLatestVersion".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.useLatestVersion
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("subject".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.subject = reader.getString();
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.expirationDate = reader.getString();
                } else if ("certificateAuthority".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.certificateAuthority = reader.getString();
                } else if ("subjectAlternativeNames".equals(fieldName)) {
                    List<String> subjectAlternativeNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomerCertificateParameters.subjectAlternativeNames = subjectAlternativeNames;
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.thumbprint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomerCertificateParameters;
        });
    }
}
