// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Customer Certificate used for https.
 */
@Fluent
public final class CustomerCertificate extends Certificate {
    /*
     * Resource reference to the Azure Key Vault certificate. Expected to be in format of
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{certificateName}
     */
    private ResourceReference secretSource;

    /*
     * Certificate version.
     */
    private String secretVersion;

    /*
     * Certificate issuing authority.
     */
    private String certificateAuthority;

    /*
     * Whether to use the latest version for the certificate
     */
    private Boolean useLatestVersion;

    /*
     * The list of SANs.
     */
    private List<String> subjectAlternativeNames;

    /*
     * Certificate thumbprint.
     */
    private String thumbprint;

    /*
     * Certificate expiration date.
     */
    private String expirationDate;

    /*
     * Subject name in the certificate.
     */
    private String subject;

    /**
     * Creates an instance of CustomerCertificate class.
     */
    public CustomerCertificate() {
    }

    /**
     * Get the secretSource property: Resource reference to the Azure Key Vault certificate. Expected to be in format of
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{certificateName}.
     *
     * @return the secretSource value.
     */
    public ResourceReference secretSource() {
        return this.secretSource;
    }

    /**
     * Set the secretSource property: Resource reference to the Azure Key Vault certificate. Expected to be in format of
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{certificateName}.
     *
     * @param secretSource the secretSource value to set.
     * @return the CustomerCertificate object itself.
     */
    public CustomerCertificate withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    /**
     * Get the secretVersion property: Certificate version.
     *
     * @return the secretVersion value.
     */
    public String secretVersion() {
        return this.secretVersion;
    }

    /**
     * Set the secretVersion property: Certificate version.
     *
     * @param secretVersion the secretVersion value to set.
     * @return the CustomerCertificate object itself.
     */
    public CustomerCertificate withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    /**
     * Get the certificateAuthority property: Certificate issuing authority.
     *
     * @return the certificateAuthority value.
     */
    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    /**
     * Get the useLatestVersion property: Whether to use the latest version for the certificate.
     *
     * @return the useLatestVersion value.
     */
    public Boolean useLatestVersion() {
        return this.useLatestVersion;
    }

    /**
     * Set the useLatestVersion property: Whether to use the latest version for the certificate.
     *
     * @param useLatestVersion the useLatestVersion value to set.
     * @return the CustomerCertificate object itself.
     */
    public CustomerCertificate withUseLatestVersion(Boolean useLatestVersion) {
        this.useLatestVersion = useLatestVersion;
        return this;
    }

    /**
     * Get the subjectAlternativeNames property: The list of SANs.
     *
     * @return the subjectAlternativeNames value.
     */
    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    /**
     * Set the subjectAlternativeNames property: The list of SANs.
     *
     * @param subjectAlternativeNames the subjectAlternativeNames value to set.
     * @return the CustomerCertificate object itself.
     */
    public CustomerCertificate withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    /**
     * Get the thumbprint property: Certificate thumbprint.
     *
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Get the expirationDate property: Certificate expiration date.
     *
     * @return the expirationDate value.
     */
    @Override
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Get the subject property: Subject name in the certificate.
     *
     * @return the subject value.
     */
    @Override
    public String subject() {
        return this.subject;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CustomerCertificate withType(SecretType type) {
        super.withType(type);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (secretSource() != null) {
            secretSource().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", type() == null ? null : type().toString());
        jsonWriter.writeJsonField("secretSource", this.secretSource);
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        jsonWriter.writeBooleanField("useLatestVersion", this.useLatestVersion);
        jsonWriter.writeArrayField("subjectAlternativeNames", this.subjectAlternativeNames,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomerCertificate from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomerCertificate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomerCertificate.
     */
    public static CustomerCertificate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomerCertificate deserializedCustomerCertificate = new CustomerCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedCustomerCertificate.withType(SecretType.fromString(reader.getString()));
                } else if ("subject".equals(fieldName)) {
                    deserializedCustomerCertificate.subject = reader.getString();
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedCustomerCertificate.expirationDate = reader.getString();
                } else if ("secretSource".equals(fieldName)) {
                    deserializedCustomerCertificate.secretSource = ResourceReference.fromJson(reader);
                } else if ("secretVersion".equals(fieldName)) {
                    deserializedCustomerCertificate.secretVersion = reader.getString();
                } else if ("certificateAuthority".equals(fieldName)) {
                    deserializedCustomerCertificate.certificateAuthority = reader.getString();
                } else if ("useLatestVersion".equals(fieldName)) {
                    deserializedCustomerCertificate.useLatestVersion = reader.getNullable(JsonReader::getBoolean);
                } else if ("subjectAlternativeNames".equals(fieldName)) {
                    List<String> subjectAlternativeNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomerCertificate.subjectAlternativeNames = subjectAlternativeNames;
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedCustomerCertificate.thumbprint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomerCertificate;
        });
    }
}
