// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
 */
@Fluent
public final class CacheConfiguration implements JsonSerializable<CacheConfiguration> {
    /*
     * Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching,
     * ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
     */
    private RuleQueryStringCachingBehavior queryStringCachingBehavior;

    /*
     * query parameters to include or exclude (comma separated).
     */
    private String queryParameters;

    /*
     * Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed
     * if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content
     * is smaller than 1 byte or larger than 1 MB.
     */
    private RuleIsCompressionEnabled isCompressionEnabled;

    /*
     * Caching behavior for the requests
     */
    private RuleCacheBehavior cacheBehavior;

    /*
     * The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
     */
    private String cacheDuration;

    /**
     * Creates an instance of CacheConfiguration class.
     */
    public CacheConfiguration() {
    }

    /**
     * Get the queryStringCachingBehavior property: Defines how Frontdoor caches requests that include query strings.
     * You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique
     * URL, or cache specific query strings.
     * 
     * @return the queryStringCachingBehavior value.
     */
    public RuleQueryStringCachingBehavior queryStringCachingBehavior() {
        return this.queryStringCachingBehavior;
    }

    /**
     * Set the queryStringCachingBehavior property: Defines how Frontdoor caches requests that include query strings.
     * You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique
     * URL, or cache specific query strings.
     * 
     * @param queryStringCachingBehavior the queryStringCachingBehavior value to set.
     * @return the CacheConfiguration object itself.
     */
    public CacheConfiguration
        withQueryStringCachingBehavior(RuleQueryStringCachingBehavior queryStringCachingBehavior) {
        this.queryStringCachingBehavior = queryStringCachingBehavior;
        return this;
    }

    /**
     * Get the queryParameters property: query parameters to include or exclude (comma separated).
     * 
     * @return the queryParameters value.
     */
    public String queryParameters() {
        return this.queryParameters;
    }

    /**
     * Set the queryParameters property: query parameters to include or exclude (comma separated).
     * 
     * @param queryParameters the queryParameters value to set.
     * @return the CacheConfiguration object itself.
     */
    public CacheConfiguration withQueryParameters(String queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    /**
     * Get the isCompressionEnabled property: Indicates whether content compression is enabled. If compression is
     * enabled, content will be served as compressed if user requests for a compressed version. Content won't be
     * compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     * 
     * @return the isCompressionEnabled value.
     */
    public RuleIsCompressionEnabled isCompressionEnabled() {
        return this.isCompressionEnabled;
    }

    /**
     * Set the isCompressionEnabled property: Indicates whether content compression is enabled. If compression is
     * enabled, content will be served as compressed if user requests for a compressed version. Content won't be
     * compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     * 
     * @param isCompressionEnabled the isCompressionEnabled value to set.
     * @return the CacheConfiguration object itself.
     */
    public CacheConfiguration withIsCompressionEnabled(RuleIsCompressionEnabled isCompressionEnabled) {
        this.isCompressionEnabled = isCompressionEnabled;
        return this;
    }

    /**
     * Get the cacheBehavior property: Caching behavior for the requests.
     * 
     * @return the cacheBehavior value.
     */
    public RuleCacheBehavior cacheBehavior() {
        return this.cacheBehavior;
    }

    /**
     * Set the cacheBehavior property: Caching behavior for the requests.
     * 
     * @param cacheBehavior the cacheBehavior value to set.
     * @return the CacheConfiguration object itself.
     */
    public CacheConfiguration withCacheBehavior(RuleCacheBehavior cacheBehavior) {
        this.cacheBehavior = cacheBehavior;
        return this;
    }

    /**
     * Get the cacheDuration property: The duration for which the content needs to be cached. Allowed format is
     * [d.]hh:mm:ss.
     * 
     * @return the cacheDuration value.
     */
    public String cacheDuration() {
        return this.cacheDuration;
    }

    /**
     * Set the cacheDuration property: The duration for which the content needs to be cached. Allowed format is
     * [d.]hh:mm:ss.
     * 
     * @param cacheDuration the cacheDuration value to set.
     * @return the CacheConfiguration object itself.
     */
    public CacheConfiguration withCacheDuration(String cacheDuration) {
        this.cacheDuration = cacheDuration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queryStringCachingBehavior",
            this.queryStringCachingBehavior == null ? null : this.queryStringCachingBehavior.toString());
        jsonWriter.writeStringField("queryParameters", this.queryParameters);
        jsonWriter.writeStringField("isCompressionEnabled",
            this.isCompressionEnabled == null ? null : this.isCompressionEnabled.toString());
        jsonWriter.writeStringField("cacheBehavior", this.cacheBehavior == null ? null : this.cacheBehavior.toString());
        jsonWriter.writeStringField("cacheDuration", this.cacheDuration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CacheConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CacheConfiguration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CacheConfiguration.
     */
    public static CacheConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CacheConfiguration deserializedCacheConfiguration = new CacheConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("queryStringCachingBehavior".equals(fieldName)) {
                    deserializedCacheConfiguration.queryStringCachingBehavior
                        = RuleQueryStringCachingBehavior.fromString(reader.getString());
                } else if ("queryParameters".equals(fieldName)) {
                    deserializedCacheConfiguration.queryParameters = reader.getString();
                } else if ("isCompressionEnabled".equals(fieldName)) {
                    deserializedCacheConfiguration.isCompressionEnabled
                        = RuleIsCompressionEnabled.fromString(reader.getString());
                } else if ("cacheBehavior".equals(fieldName)) {
                    deserializedCacheConfiguration.cacheBehavior = RuleCacheBehavior.fromString(reader.getString());
                } else if ("cacheDuration".equals(fieldName)) {
                    deserializedCacheConfiguration.cacheDuration = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCacheConfiguration;
        });
    }
}
