// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourceUsageUnit;
import java.io.IOException;

/**
 * Output of check resource usage API.
 */
@Immutable
public final class ResourceUsageInner implements JsonSerializable<ResourceUsageInner> {
    /*
     * Resource type for which the usage is provided.
     */
    private String resourceType;

    /*
     * Unit of the usage. e.g. count.
     */
    private ResourceUsageUnit unit;

    /*
     * Actual value of usage on the specified resource type.
     */
    private Integer currentValue;

    /*
     * Quota of the specified resource type.
     */
    private Integer limit;

    /**
     * Creates an instance of ResourceUsageInner class.
     */
    public ResourceUsageInner() {
    }

    /**
     * Get the resourceType property: Resource type for which the usage is provided.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Get the unit property: Unit of the usage. e.g. count.
     * 
     * @return the unit value.
     */
    public ResourceUsageUnit unit() {
        return this.unit;
    }

    /**
     * Get the currentValue property: Actual value of usage on the specified resource type.
     * 
     * @return the currentValue value.
     */
    public Integer currentValue() {
        return this.currentValue;
    }

    /**
     * Get the limit property: Quota of the specified resource type.
     * 
     * @return the limit value.
     */
    public Integer limit() {
        return this.limit;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceUsageInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceUsageInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceUsageInner.
     */
    public static ResourceUsageInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceUsageInner deserializedResourceUsageInner = new ResourceUsageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceType".equals(fieldName)) {
                    deserializedResourceUsageInner.resourceType = reader.getString();
                } else if ("unit".equals(fieldName)) {
                    deserializedResourceUsageInner.unit = ResourceUsageUnit.fromString(reader.getString());
                } else if ("currentValue".equals(fieldName)) {
                    deserializedResourceUsageInner.currentValue = reader.getNullable(JsonReader::getInt);
                } else if ("limit".equals(fieldName)) {
                    deserializedResourceUsageInner.limit = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceUsageInner;
        });
    }
}
