// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.MetricsGranularity;
import com.azure.resourcemanager.cdn.models.MetricsResponseSeriesItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Metrics Response.
 */
@Fluent
public final class MetricsResponseInner implements JsonSerializable<MetricsResponseInner> {
    /*
     * The dateTimeBegin property.
     */
    private OffsetDateTime dateTimeBegin;

    /*
     * The dateTimeEnd property.
     */
    private OffsetDateTime dateTimeEnd;

    /*
     * The granularity property.
     */
    private MetricsGranularity granularity;

    /*
     * The series property.
     */
    private List<MetricsResponseSeriesItem> series;

    /**
     * Creates an instance of MetricsResponseInner class.
     */
    public MetricsResponseInner() {
    }

    /**
     * Get the dateTimeBegin property: The dateTimeBegin property.
     * 
     * @return the dateTimeBegin value.
     */
    public OffsetDateTime dateTimeBegin() {
        return this.dateTimeBegin;
    }

    /**
     * Set the dateTimeBegin property: The dateTimeBegin property.
     * 
     * @param dateTimeBegin the dateTimeBegin value to set.
     * @return the MetricsResponseInner object itself.
     */
    public MetricsResponseInner withDateTimeBegin(OffsetDateTime dateTimeBegin) {
        this.dateTimeBegin = dateTimeBegin;
        return this;
    }

    /**
     * Get the dateTimeEnd property: The dateTimeEnd property.
     * 
     * @return the dateTimeEnd value.
     */
    public OffsetDateTime dateTimeEnd() {
        return this.dateTimeEnd;
    }

    /**
     * Set the dateTimeEnd property: The dateTimeEnd property.
     * 
     * @param dateTimeEnd the dateTimeEnd value to set.
     * @return the MetricsResponseInner object itself.
     */
    public MetricsResponseInner withDateTimeEnd(OffsetDateTime dateTimeEnd) {
        this.dateTimeEnd = dateTimeEnd;
        return this;
    }

    /**
     * Get the granularity property: The granularity property.
     * 
     * @return the granularity value.
     */
    public MetricsGranularity granularity() {
        return this.granularity;
    }

    /**
     * Set the granularity property: The granularity property.
     * 
     * @param granularity the granularity value to set.
     * @return the MetricsResponseInner object itself.
     */
    public MetricsResponseInner withGranularity(MetricsGranularity granularity) {
        this.granularity = granularity;
        return this;
    }

    /**
     * Get the series property: The series property.
     * 
     * @return the series value.
     */
    public List<MetricsResponseSeriesItem> series() {
        return this.series;
    }

    /**
     * Set the series property: The series property.
     * 
     * @param series the series value to set.
     * @return the MetricsResponseInner object itself.
     */
    public MetricsResponseInner withSeries(List<MetricsResponseSeriesItem> series) {
        this.series = series;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (series() != null) {
            series().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dateTimeBegin",
            this.dateTimeBegin == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dateTimeBegin));
        jsonWriter.writeStringField("dateTimeEnd",
            this.dateTimeEnd == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dateTimeEnd));
        jsonWriter.writeStringField("granularity", this.granularity == null ? null : this.granularity.toString());
        jsonWriter.writeArrayField("series", this.series, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricsResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricsResponseInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricsResponseInner.
     */
    public static MetricsResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricsResponseInner deserializedMetricsResponseInner = new MetricsResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dateTimeBegin".equals(fieldName)) {
                    deserializedMetricsResponseInner.dateTimeBegin = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("dateTimeEnd".equals(fieldName)) {
                    deserializedMetricsResponseInner.dateTimeEnd = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("granularity".equals(fieldName)) {
                    deserializedMetricsResponseInner.granularity = MetricsGranularity.fromString(reader.getString());
                } else if ("series".equals(fieldName)) {
                    List<MetricsResponseSeriesItem> series
                        = reader.readArray(reader1 -> MetricsResponseSeriesItem.fromJson(reader1));
                    deserializedMetricsResponseInner.series = series;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricsResponseInner;
        });
    }
}
