// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.LoadBalancingSettingsParameters;
import java.io.IOException;

/**
 * The JSON object that contains the properties of the origin group.
 */
@Fluent
public final class AfdOriginGroupProperties extends AfdOriginGroupUpdatePropertiesParameters {
    /*
     * Provisioning status
     */
    private AfdProvisioningState provisioningState;

    /*
     * The deploymentStatus property.
     */
    private DeploymentStatus deploymentStatus;

    /*
     * The name of the profile which holds the origin group.
     */
    private String profileName;

    /**
     * Creates an instance of AfdOriginGroupProperties class.
     */
    public AfdOriginGroupProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning status.
     * 
     * @return the provisioningState value.
     */
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the deploymentStatus property: The deploymentStatus property.
     * 
     * @return the deploymentStatus value.
     */
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    /**
     * Get the profileName property: The name of the profile which holds the origin group.
     * 
     * @return the profileName value.
     */
    @Override
    public String profileName() {
        return this.profileName;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AfdOriginGroupProperties withLoadBalancingSettings(LoadBalancingSettingsParameters loadBalancingSettings) {
        super.withLoadBalancingSettings(loadBalancingSettings);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AfdOriginGroupProperties withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        super.withHealthProbeSettings(healthProbeSettings);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AfdOriginGroupProperties withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(
        Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        super.withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(
            trafficRestorationTimeToHealedOrNewEndpointsInMinutes);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AfdOriginGroupProperties withSessionAffinityState(EnabledState sessionAffinityState) {
        super.withSessionAffinityState(sessionAffinityState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("loadBalancingSettings", loadBalancingSettings());
        jsonWriter.writeJsonField("healthProbeSettings", healthProbeSettings());
        jsonWriter.writeNumberField("trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            trafficRestorationTimeToHealedOrNewEndpointsInMinutes());
        jsonWriter.writeStringField("sessionAffinityState",
            sessionAffinityState() == null ? null : sessionAffinityState().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AfdOriginGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AfdOriginGroupProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AfdOriginGroupProperties.
     */
    public static AfdOriginGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AfdOriginGroupProperties deserializedAfdOriginGroupProperties = new AfdOriginGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("profileName".equals(fieldName)) {
                    deserializedAfdOriginGroupProperties.profileName = reader.getString();
                } else if ("loadBalancingSettings".equals(fieldName)) {
                    deserializedAfdOriginGroupProperties
                        .withLoadBalancingSettings(LoadBalancingSettingsParameters.fromJson(reader));
                } else if ("healthProbeSettings".equals(fieldName)) {
                    deserializedAfdOriginGroupProperties
                        .withHealthProbeSettings(HealthProbeParameters.fromJson(reader));
                } else if ("trafficRestorationTimeToHealedOrNewEndpointsInMinutes".equals(fieldName)) {
                    deserializedAfdOriginGroupProperties.withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(
                        reader.getNullable(JsonReader::getInt));
                } else if ("sessionAffinityState".equals(fieldName)) {
                    deserializedAfdOriginGroupProperties
                        .withSessionAffinityState(EnabledState.fromString(reader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedAfdOriginGroupProperties.provisioningState
                        = AfdProvisioningState.fromString(reader.getString());
                } else if ("deploymentStatus".equals(fieldName)) {
                    deserializedAfdOriginGroupProperties.deploymentStatus
                        = DeploymentStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAfdOriginGroupProperties;
        });
    }
}
