/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.CdnWebApplicationFirewallPolicyProperties;
import com.azure.resourcemanager.cdn.models.CustomRuleList;
import com.azure.resourcemanager.cdn.models.EndpointResource;
import com.azure.resourcemanager.cdn.models.ManagedRuleSetList;
import com.azure.resourcemanager.cdn.models.PolicyResourceState;
import com.azure.resourcemanager.cdn.models.PolicySettings;
import com.azure.resourcemanager.cdn.models.ProvisioningState;
import com.azure.resourcemanager.cdn.models.RateLimitRuleList;
import com.azure.resourcemanager.cdn.models.Sku;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CdnWebApplicationFirewallPolicyInner
extends Resource {
    private CdnWebApplicationFirewallPolicyProperties innerProperties;
    private String etag;
    private Sku sku;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(CdnWebApplicationFirewallPolicyInner.class);

    private CdnWebApplicationFirewallPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public CdnWebApplicationFirewallPolicyInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public CdnWebApplicationFirewallPolicyInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public CdnWebApplicationFirewallPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CdnWebApplicationFirewallPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public PolicySettings policySettings() {
        return this.innerProperties() == null ? null : this.innerProperties().policySettings();
    }

    public CdnWebApplicationFirewallPolicyInner withPolicySettings(PolicySettings policySettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CdnWebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withPolicySettings(policySettings);
        return this;
    }

    public RateLimitRuleList rateLimitRules() {
        return this.innerProperties() == null ? null : this.innerProperties().rateLimitRules();
    }

    public CdnWebApplicationFirewallPolicyInner withRateLimitRules(RateLimitRuleList rateLimitRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CdnWebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withRateLimitRules(rateLimitRules);
        return this;
    }

    public CustomRuleList customRules() {
        return this.innerProperties() == null ? null : this.innerProperties().customRules();
    }

    public CdnWebApplicationFirewallPolicyInner withCustomRules(CustomRuleList customRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CdnWebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withCustomRules(customRules);
        return this;
    }

    public ManagedRuleSetList managedRules() {
        return this.innerProperties() == null ? null : this.innerProperties().managedRules();
    }

    public CdnWebApplicationFirewallPolicyInner withManagedRules(ManagedRuleSetList managedRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CdnWebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withManagedRules(managedRules);
        return this;
    }

    public List<EndpointResource> endpointLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointLinks();
    }

    public Map<String, String> extendedProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().extendedProperties();
    }

    public CdnWebApplicationFirewallPolicyInner withExtendedProperties(Map<String, String> extendedProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CdnWebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withExtendedProperties(extendedProperties);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PolicyResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model CdnWebApplicationFirewallPolicyInner"));
        }
        this.sku().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static CdnWebApplicationFirewallPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (CdnWebApplicationFirewallPolicyInner)((Object)jsonReader.readObject(reader -> {
            CdnWebApplicationFirewallPolicyInner deserializedCdnWebApplicationFirewallPolicyInner = new CdnWebApplicationFirewallPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCdnWebApplicationFirewallPolicyInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyInner.innerProperties = CdnWebApplicationFirewallPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCdnWebApplicationFirewallPolicyInner;
        }));
    }
}

