// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the parameters for using a user's KeyVault for URL Signing Key.
 */
@Fluent
public final class KeyVaultSigningKeyParameters implements JsonSerializable<KeyVaultSigningKeyParameters> {
    /*
     * The typeName property.
     */
    private String typeName = "KeyVaultSigningKeyParameters";

    /*
     * Subscription Id of the user's Key Vault containing the secret
     */
    private String subscriptionId;

    /*
     * Resource group of the user's Key Vault containing the secret
     */
    private String resourceGroupName;

    /*
     * The name of the user's Key Vault containing the secret
     */
    private String vaultName;

    /*
     * The name of secret in Key Vault.
     */
    private String secretName;

    /*
     * The version(GUID) of secret in Key Vault.
     */
    private String secretVersion;

    /**
     * Creates an instance of KeyVaultSigningKeyParameters class.
     */
    public KeyVaultSigningKeyParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the subscriptionId property: Subscription Id of the user's Key Vault containing the secret.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set the subscriptionId property: Subscription Id of the user's Key Vault containing the secret.
     * 
     * @param subscriptionId the subscriptionId value to set.
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Get the resourceGroupName property: Resource group of the user's Key Vault containing the secret.
     * 
     * @return the resourceGroupName value.
     */
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    /**
     * Set the resourceGroupName property: Resource group of the user's Key Vault containing the secret.
     * 
     * @param resourceGroupName the resourceGroupName value to set.
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    /**
     * Get the vaultName property: The name of the user's Key Vault containing the secret.
     * 
     * @return the vaultName value.
     */
    public String vaultName() {
        return this.vaultName;
    }

    /**
     * Set the vaultName property: The name of the user's Key Vault containing the secret.
     * 
     * @param vaultName the vaultName value to set.
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withVaultName(String vaultName) {
        this.vaultName = vaultName;
        return this;
    }

    /**
     * Get the secretName property: The name of secret in Key Vault.
     * 
     * @return the secretName value.
     */
    public String secretName() {
        return this.secretName;
    }

    /**
     * Set the secretName property: The name of secret in Key Vault.
     * 
     * @param secretName the secretName value to set.
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withSecretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    /**
     * Get the secretVersion property: The version(GUID) of secret in Key Vault.
     * 
     * @return the secretVersion value.
     */
    public String secretVersion() {
        return this.secretVersion;
    }

    /**
     * Set the secretVersion property: The version(GUID) of secret in Key Vault.
     * 
     * @param secretVersion the secretVersion value to set.
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subscriptionId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property subscriptionId in model KeyVaultSigningKeyParameters"));
        }
        if (resourceGroupName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property resourceGroupName in model KeyVaultSigningKeyParameters"));
        }
        if (vaultName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property vaultName in model KeyVaultSigningKeyParameters"));
        }
        if (secretName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property secretName in model KeyVaultSigningKeyParameters"));
        }
        if (secretVersion() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property secretVersion in model KeyVaultSigningKeyParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultSigningKeyParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroupName", this.resourceGroupName);
        jsonWriter.writeStringField("vaultName", this.vaultName);
        jsonWriter.writeStringField("secretName", this.secretName);
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultSigningKeyParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultSigningKeyParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyVaultSigningKeyParameters.
     */
    public static KeyVaultSigningKeyParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultSigningKeyParameters deserializedKeyVaultSigningKeyParameters = new KeyVaultSigningKeyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subscriptionId".equals(fieldName)) {
                    deserializedKeyVaultSigningKeyParameters.subscriptionId = reader.getString();
                } else if ("resourceGroupName".equals(fieldName)) {
                    deserializedKeyVaultSigningKeyParameters.resourceGroupName = reader.getString();
                } else if ("vaultName".equals(fieldName)) {
                    deserializedKeyVaultSigningKeyParameters.vaultName = reader.getString();
                } else if ("secretName".equals(fieldName)) {
                    deserializedKeyVaultSigningKeyParameters.secretName = reader.getString();
                } else if ("secretVersion".equals(fieldName)) {
                    deserializedKeyVaultSigningKeyParameters.secretVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultSigningKeyParameters;
        });
    }
}
