// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

/**
 * Action of the geo filter, i.e. allow or block access.
 */
public enum GeoFilterActions {
    /**
     * Enum value Block.
     */
    BLOCK("Block"),

    /**
     * Enum value Allow.
     */
    ALLOW("Allow");

    /**
     * The actual serialized value for a GeoFilterActions instance.
     */
    private final String value;

    GeoFilterActions(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a GeoFilterActions instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed GeoFilterActions object, or null if unable to parse.
     */
    public static GeoFilterActions fromString(String value) {
        if (value == null) {
            return null;
        }
        GeoFilterActions[] items = GeoFilterActions.values();
        for (GeoFilterActions item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
