// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ContinentsResponseCountryOrRegionsItem model.
 */
@Fluent
public final class ContinentsResponseCountryOrRegionsItem
    implements JsonSerializable<ContinentsResponseCountryOrRegionsItem> {
    /*
     * The id property.
     */
    private String id;

    /*
     * The continentId property.
     */
    private String continentId;

    /**
     * Creates an instance of ContinentsResponseCountryOrRegionsItem class.
     */
    public ContinentsResponseCountryOrRegionsItem() {
    }

    /**
     * Get the id property: The id property.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id property.
     * 
     * @param id the id value to set.
     * @return the ContinentsResponseCountryOrRegionsItem object itself.
     */
    public ContinentsResponseCountryOrRegionsItem withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the continentId property: The continentId property.
     * 
     * @return the continentId value.
     */
    public String continentId() {
        return this.continentId;
    }

    /**
     * Set the continentId property: The continentId property.
     * 
     * @param continentId the continentId value to set.
     * @return the ContinentsResponseCountryOrRegionsItem object itself.
     */
    public ContinentsResponseCountryOrRegionsItem withContinentId(String continentId) {
        this.continentId = continentId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("continentId", this.continentId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContinentsResponseCountryOrRegionsItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContinentsResponseCountryOrRegionsItem if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContinentsResponseCountryOrRegionsItem.
     */
    public static ContinentsResponseCountryOrRegionsItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContinentsResponseCountryOrRegionsItem deserializedContinentsResponseCountryOrRegionsItem
                = new ContinentsResponseCountryOrRegionsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedContinentsResponseCountryOrRegionsItem.id = reader.getString();
                } else if ("continentId".equals(fieldName)) {
                    deserializedContinentsResponseCountryOrRegionsItem.continentId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContinentsResponseCountryOrRegionsItem;
        });
    }
}
