// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the parameters for the cache expiration action.
 */
@Fluent
public final class CacheExpirationActionParameters implements JsonSerializable<CacheExpirationActionParameters> {
    /*
     * The typeName property.
     */
    private String typeName = "DeliveryRuleCacheExpirationActionParameters";

    /*
     * Caching behavior for the requests
     */
    private CacheBehavior cacheBehavior;

    /*
     * The level at which the content needs to be cached.
     */
    private CacheType cacheType;

    /*
     * The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
     */
    private String cacheDuration;

    /**
     * Creates an instance of CacheExpirationActionParameters class.
     */
    public CacheExpirationActionParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the CacheExpirationActionParameters object itself.
     */
    public CacheExpirationActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the cacheBehavior property: Caching behavior for the requests.
     * 
     * @return the cacheBehavior value.
     */
    public CacheBehavior cacheBehavior() {
        return this.cacheBehavior;
    }

    /**
     * Set the cacheBehavior property: Caching behavior for the requests.
     * 
     * @param cacheBehavior the cacheBehavior value to set.
     * @return the CacheExpirationActionParameters object itself.
     */
    public CacheExpirationActionParameters withCacheBehavior(CacheBehavior cacheBehavior) {
        this.cacheBehavior = cacheBehavior;
        return this;
    }

    /**
     * Get the cacheType property: The level at which the content needs to be cached.
     * 
     * @return the cacheType value.
     */
    public CacheType cacheType() {
        return this.cacheType;
    }

    /**
     * Set the cacheType property: The level at which the content needs to be cached.
     * 
     * @param cacheType the cacheType value to set.
     * @return the CacheExpirationActionParameters object itself.
     */
    public CacheExpirationActionParameters withCacheType(CacheType cacheType) {
        this.cacheType = cacheType;
        return this;
    }

    /**
     * Get the cacheDuration property: The duration for which the content needs to be cached. Allowed format is
     * [d.]hh:mm:ss.
     * 
     * @return the cacheDuration value.
     */
    public String cacheDuration() {
        return this.cacheDuration;
    }

    /**
     * Set the cacheDuration property: The duration for which the content needs to be cached. Allowed format is
     * [d.]hh:mm:ss.
     * 
     * @param cacheDuration the cacheDuration value to set.
     * @return the CacheExpirationActionParameters object itself.
     */
    public CacheExpirationActionParameters withCacheDuration(String cacheDuration) {
        this.cacheDuration = cacheDuration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (cacheBehavior() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property cacheBehavior in model CacheExpirationActionParameters"));
        }
        if (cacheType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property cacheType in model CacheExpirationActionParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CacheExpirationActionParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("cacheBehavior", this.cacheBehavior == null ? null : this.cacheBehavior.toString());
        jsonWriter.writeStringField("cacheType", this.cacheType == null ? null : this.cacheType.toString());
        jsonWriter.writeStringField("cacheDuration", this.cacheDuration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CacheExpirationActionParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CacheExpirationActionParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CacheExpirationActionParameters.
     */
    public static CacheExpirationActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CacheExpirationActionParameters deserializedCacheExpirationActionParameters
                = new CacheExpirationActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cacheBehavior".equals(fieldName)) {
                    deserializedCacheExpirationActionParameters.cacheBehavior
                        = CacheBehavior.fromString(reader.getString());
                } else if ("cacheType".equals(fieldName)) {
                    deserializedCacheExpirationActionParameters.cacheType = CacheType.fromString(reader.getString());
                } else if ("cacheDuration".equals(fieldName)) {
                    deserializedCacheExpirationActionParameters.cacheDuration = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCacheExpirationActionParameters;
        });
    }
}
