// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ActivatedResourceReference;
import com.azure.resourcemanager.cdn.models.AfdEndpointProtocols;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.AfdRouteCacheConfiguration;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.ForwardingProtocol;
import com.azure.resourcemanager.cdn.models.HttpsRedirect;
import com.azure.resourcemanager.cdn.models.LinkToDefaultDomain;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;
import java.util.List;

/**
 * The JSON object that contains the properties of the Routes to create.
 */
@Fluent
public final class RouteProperties extends RouteUpdatePropertiesParameters {
    /*
     * Provisioning status
     */
    private AfdProvisioningState provisioningState;

    /*
     * The deploymentStatus property.
     */
    private DeploymentStatus deploymentStatus;

    /*
     * The name of the endpoint which holds the route.
     */
    private String endpointName;

    /**
     * Creates an instance of RouteProperties class.
     */
    public RouteProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning status.
     * 
     * @return the provisioningState value.
     */
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the deploymentStatus property: The deploymentStatus property.
     * 
     * @return the deploymentStatus value.
     */
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    /**
     * Get the endpointName property: The name of the endpoint which holds the route.
     * 
     * @return the endpointName value.
     */
    @Override
    public String endpointName() {
        return this.endpointName;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withCustomDomains(List<ActivatedResourceReference> customDomains) {
        super.withCustomDomains(customDomains);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withOriginGroup(ResourceReference originGroup) {
        super.withOriginGroup(originGroup);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withOriginPath(String originPath) {
        super.withOriginPath(originPath);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withRuleSets(List<ResourceReference> ruleSets) {
        super.withRuleSets(ruleSets);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withSupportedProtocols(List<AfdEndpointProtocols> supportedProtocols) {
        super.withSupportedProtocols(supportedProtocols);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withPatternsToMatch(List<String> patternsToMatch) {
        super.withPatternsToMatch(patternsToMatch);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withCacheConfiguration(AfdRouteCacheConfiguration cacheConfiguration) {
        super.withCacheConfiguration(cacheConfiguration);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withForwardingProtocol(ForwardingProtocol forwardingProtocol) {
        super.withForwardingProtocol(forwardingProtocol);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withLinkToDefaultDomain(LinkToDefaultDomain linkToDefaultDomain) {
        super.withLinkToDefaultDomain(linkToDefaultDomain);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withHttpsRedirect(HttpsRedirect httpsRedirect) {
        super.withHttpsRedirect(httpsRedirect);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteProperties withEnabledState(EnabledState enabledState) {
        super.withEnabledState(enabledState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("customDomains", customDomains(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("originGroup", originGroup());
        jsonWriter.writeStringField("originPath", originPath());
        jsonWriter.writeArrayField("ruleSets", ruleSets(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("supportedProtocols", supportedProtocols(),
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("patternsToMatch", patternsToMatch(),
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("cacheConfiguration", cacheConfiguration());
        jsonWriter.writeStringField("forwardingProtocol",
            forwardingProtocol() == null ? null : forwardingProtocol().toString());
        jsonWriter.writeStringField("linkToDefaultDomain",
            linkToDefaultDomain() == null ? null : linkToDefaultDomain().toString());
        jsonWriter.writeStringField("httpsRedirect", httpsRedirect() == null ? null : httpsRedirect().toString());
        jsonWriter.writeStringField("enabledState", enabledState() == null ? null : enabledState().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RouteProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RouteProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RouteProperties.
     */
    public static RouteProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteProperties deserializedRouteProperties = new RouteProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endpointName".equals(fieldName)) {
                    deserializedRouteProperties.endpointName = reader.getString();
                } else if ("customDomains".equals(fieldName)) {
                    List<ActivatedResourceReference> customDomains
                        = reader.readArray(reader1 -> ActivatedResourceReference.fromJson(reader1));
                    deserializedRouteProperties.withCustomDomains(customDomains);
                } else if ("originGroup".equals(fieldName)) {
                    deserializedRouteProperties.withOriginGroup(ResourceReference.fromJson(reader));
                } else if ("originPath".equals(fieldName)) {
                    deserializedRouteProperties.withOriginPath(reader.getString());
                } else if ("ruleSets".equals(fieldName)) {
                    List<ResourceReference> ruleSets = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedRouteProperties.withRuleSets(ruleSets);
                } else if ("supportedProtocols".equals(fieldName)) {
                    List<AfdEndpointProtocols> supportedProtocols
                        = reader.readArray(reader1 -> AfdEndpointProtocols.fromString(reader1.getString()));
                    deserializedRouteProperties.withSupportedProtocols(supportedProtocols);
                } else if ("patternsToMatch".equals(fieldName)) {
                    List<String> patternsToMatch = reader.readArray(reader1 -> reader1.getString());
                    deserializedRouteProperties.withPatternsToMatch(patternsToMatch);
                } else if ("cacheConfiguration".equals(fieldName)) {
                    deserializedRouteProperties.withCacheConfiguration(AfdRouteCacheConfiguration.fromJson(reader));
                } else if ("forwardingProtocol".equals(fieldName)) {
                    deserializedRouteProperties
                        .withForwardingProtocol(ForwardingProtocol.fromString(reader.getString()));
                } else if ("linkToDefaultDomain".equals(fieldName)) {
                    deserializedRouteProperties
                        .withLinkToDefaultDomain(LinkToDefaultDomain.fromString(reader.getString()));
                } else if ("httpsRedirect".equals(fieldName)) {
                    deserializedRouteProperties.withHttpsRedirect(HttpsRedirect.fromString(reader.getString()));
                } else if ("enabledState".equals(fieldName)) {
                    deserializedRouteProperties.withEnabledState(EnabledState.fromString(reader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRouteProperties.provisioningState = AfdProvisioningState.fromString(reader.getString());
                } else if ("deploymentStatus".equals(fieldName)) {
                    deserializedRouteProperties.deploymentStatus = DeploymentStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRouteProperties;
        });
    }
}
