// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ContinentsResponseContinentsItem;
import com.azure.resourcemanager.cdn.models.ContinentsResponseCountryOrRegionsItem;
import java.io.IOException;
import java.util.List;

/**
 * Continents Response.
 */
@Fluent
public final class ContinentsResponseInner implements JsonSerializable<ContinentsResponseInner> {
    /*
     * The continents property.
     */
    private List<ContinentsResponseContinentsItem> continents;

    /*
     * The countryOrRegions property.
     */
    private List<ContinentsResponseCountryOrRegionsItem> countryOrRegions;

    /**
     * Creates an instance of ContinentsResponseInner class.
     */
    public ContinentsResponseInner() {
    }

    /**
     * Get the continents property: The continents property.
     * 
     * @return the continents value.
     */
    public List<ContinentsResponseContinentsItem> continents() {
        return this.continents;
    }

    /**
     * Set the continents property: The continents property.
     * 
     * @param continents the continents value to set.
     * @return the ContinentsResponseInner object itself.
     */
    public ContinentsResponseInner withContinents(List<ContinentsResponseContinentsItem> continents) {
        this.continents = continents;
        return this;
    }

    /**
     * Get the countryOrRegions property: The countryOrRegions property.
     * 
     * @return the countryOrRegions value.
     */
    public List<ContinentsResponseCountryOrRegionsItem> countryOrRegions() {
        return this.countryOrRegions;
    }

    /**
     * Set the countryOrRegions property: The countryOrRegions property.
     * 
     * @param countryOrRegions the countryOrRegions value to set.
     * @return the ContinentsResponseInner object itself.
     */
    public ContinentsResponseInner withCountryOrRegions(List<ContinentsResponseCountryOrRegionsItem> countryOrRegions) {
        this.countryOrRegions = countryOrRegions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (continents() != null) {
            continents().forEach(e -> e.validate());
        }
        if (countryOrRegions() != null) {
            countryOrRegions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("continents", this.continents, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("countryOrRegions", this.countryOrRegions,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContinentsResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContinentsResponseInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContinentsResponseInner.
     */
    public static ContinentsResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContinentsResponseInner deserializedContinentsResponseInner = new ContinentsResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("continents".equals(fieldName)) {
                    List<ContinentsResponseContinentsItem> continents
                        = reader.readArray(reader1 -> ContinentsResponseContinentsItem.fromJson(reader1));
                    deserializedContinentsResponseInner.continents = continents;
                } else if ("countryOrRegions".equals(fieldName)) {
                    List<ContinentsResponseCountryOrRegionsItem> countryOrRegions
                        = reader.readArray(reader1 -> ContinentsResponseCountryOrRegionsItem.fromJson(reader1));
                    deserializedContinentsResponseInner.countryOrRegions = countryOrRegions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContinentsResponseInner;
        });
    }
}
