// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Output of check name availability API.
 */
@Immutable
public final class CheckEndpointNameAvailabilityOutputInner
    implements JsonSerializable<CheckEndpointNameAvailabilityOutputInner> {
    /*
     * Indicates whether the name is available.
     */
    private Boolean nameAvailable;

    /*
     * Returns the available hostname generated based on the AutoGeneratedDomainNameLabelScope when the name is
     * available, otherwise it returns empty string
     */
    private String availableHostname;

    /*
     * The reason why the name is not available.
     */
    private String reason;

    /*
     * The detailed error message describing why the name is not available.
     */
    private String message;

    /**
     * Creates an instance of CheckEndpointNameAvailabilityOutputInner class.
     */
    public CheckEndpointNameAvailabilityOutputInner() {
    }

    /**
     * Get the nameAvailable property: Indicates whether the name is available.
     * 
     * @return the nameAvailable value.
     */
    public Boolean nameAvailable() {
        return this.nameAvailable;
    }

    /**
     * Get the availableHostname property: Returns the available hostname generated based on the
     * AutoGeneratedDomainNameLabelScope when the name is available, otherwise it returns empty string.
     * 
     * @return the availableHostname value.
     */
    public String availableHostname() {
        return this.availableHostname;
    }

    /**
     * Get the reason property: The reason why the name is not available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Get the message property: The detailed error message describing why the name is not available.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CheckEndpointNameAvailabilityOutputInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CheckEndpointNameAvailabilityOutputInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CheckEndpointNameAvailabilityOutputInner.
     */
    public static CheckEndpointNameAvailabilityOutputInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CheckEndpointNameAvailabilityOutputInner deserializedCheckEndpointNameAvailabilityOutputInner
                = new CheckEndpointNameAvailabilityOutputInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nameAvailable".equals(fieldName)) {
                    deserializedCheckEndpointNameAvailabilityOutputInner.nameAvailable
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("availableHostname".equals(fieldName)) {
                    deserializedCheckEndpointNameAvailabilityOutputInner.availableHostname = reader.getString();
                } else if ("reason".equals(fieldName)) {
                    deserializedCheckEndpointNameAvailabilityOutputInner.reason = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedCheckEndpointNameAvailabilityOutputInner.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCheckEndpointNameAvailabilityOutputInner;
        });
    }
}
