// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CustomRuleList;
import com.azure.resourcemanager.cdn.models.EndpointResource;
import com.azure.resourcemanager.cdn.models.ManagedRuleSetList;
import com.azure.resourcemanager.cdn.models.PolicyResourceState;
import com.azure.resourcemanager.cdn.models.PolicySettings;
import com.azure.resourcemanager.cdn.models.ProvisioningState;
import com.azure.resourcemanager.cdn.models.RateLimitRuleList;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Defines CDN web application firewall policy properties.
 */
@Fluent
public final class CdnWebApplicationFirewallPolicyProperties
    implements JsonSerializable<CdnWebApplicationFirewallPolicyProperties> {
    /*
     * Describes policySettings for policy
     */
    private PolicySettings policySettings;

    /*
     * Describes rate limit rules inside the policy.
     */
    private RateLimitRuleList rateLimitRules;

    /*
     * Describes custom rules inside the policy.
     */
    private CustomRuleList customRules;

    /*
     * Describes managed rules inside the policy.
     */
    private ManagedRuleSetList managedRules;

    /*
     * Describes Azure CDN endpoints associated with this Web Application Firewall policy.
     */
    private List<EndpointResource> endpointLinks;

    /*
     * Key-Value pair representing additional properties for Web Application Firewall policy.
     */
    private Map<String, String> extendedProperties;

    /*
     * Provisioning state of the WebApplicationFirewallPolicy.
     */
    private ProvisioningState provisioningState;

    /*
     * Resource status of the policy.
     */
    private PolicyResourceState resourceState;

    /**
     * Creates an instance of CdnWebApplicationFirewallPolicyProperties class.
     */
    public CdnWebApplicationFirewallPolicyProperties() {
    }

    /**
     * Get the policySettings property: Describes policySettings for policy.
     * 
     * @return the policySettings value.
     */
    public PolicySettings policySettings() {
        return this.policySettings;
    }

    /**
     * Set the policySettings property: Describes policySettings for policy.
     * 
     * @param policySettings the policySettings value to set.
     * @return the CdnWebApplicationFirewallPolicyProperties object itself.
     */
    public CdnWebApplicationFirewallPolicyProperties withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    /**
     * Get the rateLimitRules property: Describes rate limit rules inside the policy.
     * 
     * @return the rateLimitRules value.
     */
    public RateLimitRuleList rateLimitRules() {
        return this.rateLimitRules;
    }

    /**
     * Set the rateLimitRules property: Describes rate limit rules inside the policy.
     * 
     * @param rateLimitRules the rateLimitRules value to set.
     * @return the CdnWebApplicationFirewallPolicyProperties object itself.
     */
    public CdnWebApplicationFirewallPolicyProperties withRateLimitRules(RateLimitRuleList rateLimitRules) {
        this.rateLimitRules = rateLimitRules;
        return this;
    }

    /**
     * Get the customRules property: Describes custom rules inside the policy.
     * 
     * @return the customRules value.
     */
    public CustomRuleList customRules() {
        return this.customRules;
    }

    /**
     * Set the customRules property: Describes custom rules inside the policy.
     * 
     * @param customRules the customRules value to set.
     * @return the CdnWebApplicationFirewallPolicyProperties object itself.
     */
    public CdnWebApplicationFirewallPolicyProperties withCustomRules(CustomRuleList customRules) {
        this.customRules = customRules;
        return this;
    }

    /**
     * Get the managedRules property: Describes managed rules inside the policy.
     * 
     * @return the managedRules value.
     */
    public ManagedRuleSetList managedRules() {
        return this.managedRules;
    }

    /**
     * Set the managedRules property: Describes managed rules inside the policy.
     * 
     * @param managedRules the managedRules value to set.
     * @return the CdnWebApplicationFirewallPolicyProperties object itself.
     */
    public CdnWebApplicationFirewallPolicyProperties withManagedRules(ManagedRuleSetList managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    /**
     * Get the endpointLinks property: Describes Azure CDN endpoints associated with this Web Application Firewall
     * policy.
     * 
     * @return the endpointLinks value.
     */
    public List<EndpointResource> endpointLinks() {
        return this.endpointLinks;
    }

    /**
     * Get the extendedProperties property: Key-Value pair representing additional properties for Web Application
     * Firewall policy.
     * 
     * @return the extendedProperties value.
     */
    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    /**
     * Set the extendedProperties property: Key-Value pair representing additional properties for Web Application
     * Firewall policy.
     * 
     * @param extendedProperties the extendedProperties value to set.
     * @return the CdnWebApplicationFirewallPolicyProperties object itself.
     */
    public CdnWebApplicationFirewallPolicyProperties withExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the WebApplicationFirewallPolicy.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceState property: Resource status of the policy.
     * 
     * @return the resourceState value.
     */
    public PolicyResourceState resourceState() {
        return this.resourceState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (policySettings() != null) {
            policySettings().validate();
        }
        if (rateLimitRules() != null) {
            rateLimitRules().validate();
        }
        if (customRules() != null) {
            customRules().validate();
        }
        if (managedRules() != null) {
            managedRules().validate();
        }
        if (endpointLinks() != null) {
            endpointLinks().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policySettings", this.policySettings);
        jsonWriter.writeJsonField("rateLimitRules", this.rateLimitRules);
        jsonWriter.writeJsonField("customRules", this.customRules);
        jsonWriter.writeJsonField("managedRules", this.managedRules);
        jsonWriter.writeMapField("extendedProperties", this.extendedProperties,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CdnWebApplicationFirewallPolicyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CdnWebApplicationFirewallPolicyProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CdnWebApplicationFirewallPolicyProperties.
     */
    public static CdnWebApplicationFirewallPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CdnWebApplicationFirewallPolicyProperties deserializedCdnWebApplicationFirewallPolicyProperties
                = new CdnWebApplicationFirewallPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("policySettings".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.policySettings
                        = PolicySettings.fromJson(reader);
                } else if ("rateLimitRules".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.rateLimitRules
                        = RateLimitRuleList.fromJson(reader);
                } else if ("customRules".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.customRules = CustomRuleList.fromJson(reader);
                } else if ("managedRules".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.managedRules
                        = ManagedRuleSetList.fromJson(reader);
                } else if ("endpointLinks".equals(fieldName)) {
                    List<EndpointResource> endpointLinks
                        = reader.readArray(reader1 -> EndpointResource.fromJson(reader1));
                    deserializedCdnWebApplicationFirewallPolicyProperties.endpointLinks = endpointLinks;
                } else if ("extendedProperties".equals(fieldName)) {
                    Map<String, String> extendedProperties = reader.readMap(reader1 -> reader1.getString());
                    deserializedCdnWebApplicationFirewallPolicyProperties.extendedProperties = extendedProperties;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("resourceState".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.resourceState
                        = PolicyResourceState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCdnWebApplicationFirewallPolicyProperties;
        });
    }
}
