// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Defines contents of rate limit rules.
 */
@Fluent
public final class RateLimitRuleList implements JsonSerializable<RateLimitRuleList> {
    /*
     * List of rules
     */
    private List<RateLimitRule> rules;

    /**
     * Creates an instance of RateLimitRuleList class.
     */
    public RateLimitRuleList() {
    }

    /**
     * Get the rules property: List of rules.
     * 
     * @return the rules value.
     */
    public List<RateLimitRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: List of rules.
     * 
     * @param rules the rules value to set.
     * @return the RateLimitRuleList object itself.
     */
    public RateLimitRuleList withRules(List<RateLimitRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RateLimitRuleList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RateLimitRuleList if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RateLimitRuleList.
     */
    public static RateLimitRuleList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RateLimitRuleList deserializedRateLimitRuleList = new RateLimitRuleList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("rules".equals(fieldName)) {
                    List<RateLimitRule> rules = reader.readArray(reader1 -> RateLimitRule.fromJson(reader1));
                    deserializedRateLimitRuleList.rules = rules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRateLimitRuleList;
        });
    }
}
