// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Reference to another resource along with its state.
 */
@Fluent
public final class ActivatedResourceReference implements JsonSerializable<ActivatedResourceReference> {
    /*
     * Resource ID.
     */
    private String id;

    /*
     * Whether the resource is active or inactive
     */
    private Boolean isActive;

    /**
     * Creates an instance of ActivatedResourceReference class.
     */
    public ActivatedResourceReference() {
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the ActivatedResourceReference object itself.
     */
    public ActivatedResourceReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the isActive property: Whether the resource is active or inactive.
     * 
     * @return the isActive value.
     */
    public Boolean isActive() {
        return this.isActive;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ActivatedResourceReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ActivatedResourceReference if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ActivatedResourceReference.
     */
    public static ActivatedResourceReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ActivatedResourceReference deserializedActivatedResourceReference = new ActivatedResourceReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedActivatedResourceReference.id = reader.getString();
                } else if ("isActive".equals(fieldName)) {
                    deserializedActivatedResourceReference.isActive = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedActivatedResourceReference;
        });
    }
}
