// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.CustomDomainResourceState;
import com.azure.resourcemanager.cdn.models.CustomHttpsProvisioningState;
import com.azure.resourcemanager.cdn.models.CustomHttpsProvisioningSubstate;
import java.io.IOException;

/**
 * The JSON object that contains the properties of the custom domain to create.
 */
@Fluent
public final class CustomDomainProperties implements JsonSerializable<CustomDomainProperties> {
    /*
     * The host name of the custom domain. Must be a domain name.
     */
    private String hostname;

    /*
     * Resource status of the custom domain.
     */
    private CustomDomainResourceState resourceState;

    /*
     * Provisioning status of the custom domain.
     */
    private CustomHttpsProvisioningState customHttpsProvisioningState;

    /*
     * Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
     */
    private CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate;

    /*
     * Certificate parameters for securing custom HTTPS
     */
    private CustomDomainHttpsParameters customHttpsParameters;

    /*
     * Special validation or data may be required when delivering CDN to some regions due to local compliance reasons.
     * E.g. ICP license number of a custom domain is required to deliver content in China.
     */
    private String validationData;

    /*
     * Provisioning status of Custom Https of the custom domain.
     */
    private CustomHttpsProvisioningState provisioningState;

    /**
     * Creates an instance of CustomDomainProperties class.
     */
    public CustomDomainProperties() {
    }

    /**
     * Get the hostname property: The host name of the custom domain. Must be a domain name.
     * 
     * @return the hostname value.
     */
    public String hostname() {
        return this.hostname;
    }

    /**
     * Set the hostname property: The host name of the custom domain. Must be a domain name.
     * 
     * @param hostname the hostname value to set.
     * @return the CustomDomainProperties object itself.
     */
    public CustomDomainProperties withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    /**
     * Get the resourceState property: Resource status of the custom domain.
     * 
     * @return the resourceState value.
     */
    public CustomDomainResourceState resourceState() {
        return this.resourceState;
    }

    /**
     * Get the customHttpsProvisioningState property: Provisioning status of the custom domain.
     * 
     * @return the customHttpsProvisioningState value.
     */
    public CustomHttpsProvisioningState customHttpsProvisioningState() {
        return this.customHttpsProvisioningState;
    }

    /**
     * Get the customHttpsProvisioningSubstate property: Provisioning substate shows the progress of custom HTTPS
     * enabling/disabling process step by step.
     * 
     * @return the customHttpsProvisioningSubstate value.
     */
    public CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate() {
        return this.customHttpsProvisioningSubstate;
    }

    /**
     * Get the customHttpsParameters property: Certificate parameters for securing custom HTTPS.
     * 
     * @return the customHttpsParameters value.
     */
    public CustomDomainHttpsParameters customHttpsParameters() {
        return this.customHttpsParameters;
    }

    /**
     * Set the customHttpsParameters property: Certificate parameters for securing custom HTTPS.
     * 
     * @param customHttpsParameters the customHttpsParameters value to set.
     * @return the CustomDomainProperties object itself.
     */
    public CustomDomainProperties withCustomHttpsParameters(CustomDomainHttpsParameters customHttpsParameters) {
        this.customHttpsParameters = customHttpsParameters;
        return this;
    }

    /**
     * Get the validationData property: Special validation or data may be required when delivering CDN to some regions
     * due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in
     * China.
     * 
     * @return the validationData value.
     */
    public String validationData() {
        return this.validationData;
    }

    /**
     * Set the validationData property: Special validation or data may be required when delivering CDN to some regions
     * due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in
     * China.
     * 
     * @param validationData the validationData value to set.
     * @return the CustomDomainProperties object itself.
     */
    public CustomDomainProperties withValidationData(String validationData) {
        this.validationData = validationData;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning status of Custom Https of the custom domain.
     * 
     * @return the provisioningState value.
     */
    public CustomHttpsProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (hostname() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property hostname in model CustomDomainProperties"));
        }
        if (customHttpsParameters() != null) {
            customHttpsParameters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomDomainProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeJsonField("customHttpsParameters", this.customHttpsParameters);
        jsonWriter.writeStringField("validationData", this.validationData);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomDomainProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomDomainProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CustomDomainProperties.
     */
    public static CustomDomainProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDomainProperties deserializedCustomDomainProperties = new CustomDomainProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("hostName".equals(fieldName)) {
                    deserializedCustomDomainProperties.hostname = reader.getString();
                } else if ("resourceState".equals(fieldName)) {
                    deserializedCustomDomainProperties.resourceState
                        = CustomDomainResourceState.fromString(reader.getString());
                } else if ("customHttpsProvisioningState".equals(fieldName)) {
                    deserializedCustomDomainProperties.customHttpsProvisioningState
                        = CustomHttpsProvisioningState.fromString(reader.getString());
                } else if ("customHttpsProvisioningSubstate".equals(fieldName)) {
                    deserializedCustomDomainProperties.customHttpsProvisioningSubstate
                        = CustomHttpsProvisioningSubstate.fromString(reader.getString());
                } else if ("customHttpsParameters".equals(fieldName)) {
                    deserializedCustomDomainProperties.customHttpsParameters
                        = CustomDomainHttpsParameters.fromJson(reader);
                } else if ("validationData".equals(fieldName)) {
                    deserializedCustomDomainProperties.validationData = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedCustomDomainProperties.provisioningState
                        = CustomHttpsProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomDomainProperties;
        });
    }
}
