/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ProfileChangeSkuWafMapping;
import java.io.IOException;
import java.util.List;

public final class ProfileUpgradeParameters
implements JsonSerializable<ProfileUpgradeParameters> {
    private List<ProfileChangeSkuWafMapping> wafMappingList;
    private static final ClientLogger LOGGER = new ClientLogger(ProfileUpgradeParameters.class);

    public List<ProfileChangeSkuWafMapping> wafMappingList() {
        return this.wafMappingList;
    }

    public ProfileUpgradeParameters withWafMappingList(List<ProfileChangeSkuWafMapping> wafMappingList) {
        this.wafMappingList = wafMappingList;
        return this;
    }

    public void validate() {
        if (this.wafMappingList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property wafMappingList in model ProfileUpgradeParameters"));
        }
        this.wafMappingList().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("wafMappingList", this.wafMappingList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ProfileUpgradeParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ProfileUpgradeParameters)jsonReader.readObject(reader -> {
            ProfileUpgradeParameters deserializedProfileUpgradeParameters = new ProfileUpgradeParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("wafMappingList".equals(fieldName)) {
                    List wafMappingList;
                    deserializedProfileUpgradeParameters.wafMappingList = wafMappingList = reader.readArray(reader1 -> ProfileChangeSkuWafMapping.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProfileUpgradeParameters;
        });
    }
}

