/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.RouteUpdatePropertiesParameters;
import com.azure.resourcemanager.cdn.models.ActivatedResourceReference;
import com.azure.resourcemanager.cdn.models.AfdEndpointProtocols;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.AfdRouteCacheConfiguration;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.ForwardingProtocol;
import com.azure.resourcemanager.cdn.models.HttpsRedirect;
import com.azure.resourcemanager.cdn.models.LinkToDefaultDomain;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;
import java.util.List;

public final class RouteProperties
extends RouteUpdatePropertiesParameters {
    private AfdProvisioningState provisioningState;
    private DeploymentStatus deploymentStatus;
    private String endpointName;

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    @Override
    public String endpointName() {
        return this.endpointName;
    }

    @Override
    public RouteProperties withCustomDomains(List<ActivatedResourceReference> customDomains) {
        super.withCustomDomains(customDomains);
        return this;
    }

    @Override
    public RouteProperties withOriginGroup(ResourceReference originGroup) {
        super.withOriginGroup(originGroup);
        return this;
    }

    @Override
    public RouteProperties withOriginPath(String originPath) {
        super.withOriginPath(originPath);
        return this;
    }

    @Override
    public RouteProperties withRuleSets(List<ResourceReference> ruleSets) {
        super.withRuleSets(ruleSets);
        return this;
    }

    @Override
    public RouteProperties withSupportedProtocols(List<AfdEndpointProtocols> supportedProtocols) {
        super.withSupportedProtocols(supportedProtocols);
        return this;
    }

    @Override
    public RouteProperties withPatternsToMatch(List<String> patternsToMatch) {
        super.withPatternsToMatch(patternsToMatch);
        return this;
    }

    @Override
    public RouteProperties withCacheConfiguration(AfdRouteCacheConfiguration cacheConfiguration) {
        super.withCacheConfiguration(cacheConfiguration);
        return this;
    }

    @Override
    public RouteProperties withForwardingProtocol(ForwardingProtocol forwardingProtocol) {
        super.withForwardingProtocol(forwardingProtocol);
        return this;
    }

    @Override
    public RouteProperties withLinkToDefaultDomain(LinkToDefaultDomain linkToDefaultDomain) {
        super.withLinkToDefaultDomain(linkToDefaultDomain);
        return this;
    }

    @Override
    public RouteProperties withHttpsRedirect(HttpsRedirect httpsRedirect) {
        super.withHttpsRedirect(httpsRedirect);
        return this;
    }

    @Override
    public RouteProperties withEnabledState(EnabledState enabledState) {
        super.withEnabledState(enabledState);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("customDomains", this.customDomains(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("originGroup", (JsonSerializable)this.originGroup());
        jsonWriter.writeStringField("originPath", this.originPath());
        jsonWriter.writeArrayField("ruleSets", this.ruleSets(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("supportedProtocols", this.supportedProtocols(), (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("patternsToMatch", this.patternsToMatch(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("cacheConfiguration", (JsonSerializable)this.cacheConfiguration());
        jsonWriter.writeStringField("forwardingProtocol", this.forwardingProtocol() == null ? null : this.forwardingProtocol().toString());
        jsonWriter.writeStringField("linkToDefaultDomain", this.linkToDefaultDomain() == null ? null : this.linkToDefaultDomain().toString());
        jsonWriter.writeStringField("httpsRedirect", this.httpsRedirect() == null ? null : this.httpsRedirect().toString());
        jsonWriter.writeStringField("enabledState", this.enabledState() == null ? null : this.enabledState().toString());
        return jsonWriter.writeEndObject();
    }

    public static RouteProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RouteProperties)jsonReader.readObject(reader -> {
            RouteProperties deserializedRouteProperties = new RouteProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointName".equals(fieldName)) {
                    deserializedRouteProperties.endpointName = reader.getString();
                    continue;
                }
                if ("customDomains".equals(fieldName)) {
                    List customDomains = reader.readArray(reader1 -> ActivatedResourceReference.fromJson(reader1));
                    deserializedRouteProperties.withCustomDomains(customDomains);
                    continue;
                }
                if ("originGroup".equals(fieldName)) {
                    deserializedRouteProperties.withOriginGroup(ResourceReference.fromJson(reader));
                    continue;
                }
                if ("originPath".equals(fieldName)) {
                    deserializedRouteProperties.withOriginPath(reader.getString());
                    continue;
                }
                if ("ruleSets".equals(fieldName)) {
                    List ruleSets = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedRouteProperties.withRuleSets(ruleSets);
                    continue;
                }
                if ("supportedProtocols".equals(fieldName)) {
                    List supportedProtocols = reader.readArray(reader1 -> AfdEndpointProtocols.fromString(reader1.getString()));
                    deserializedRouteProperties.withSupportedProtocols(supportedProtocols);
                    continue;
                }
                if ("patternsToMatch".equals(fieldName)) {
                    List patternsToMatch = reader.readArray(reader1 -> reader1.getString());
                    deserializedRouteProperties.withPatternsToMatch(patternsToMatch);
                    continue;
                }
                if ("cacheConfiguration".equals(fieldName)) {
                    deserializedRouteProperties.withCacheConfiguration(AfdRouteCacheConfiguration.fromJson(reader));
                    continue;
                }
                if ("forwardingProtocol".equals(fieldName)) {
                    deserializedRouteProperties.withForwardingProtocol(ForwardingProtocol.fromString(reader.getString()));
                    continue;
                }
                if ("linkToDefaultDomain".equals(fieldName)) {
                    deserializedRouteProperties.withLinkToDefaultDomain(LinkToDefaultDomain.fromString(reader.getString()));
                    continue;
                }
                if ("httpsRedirect".equals(fieldName)) {
                    deserializedRouteProperties.withHttpsRedirect(HttpsRedirect.fromString(reader.getString()));
                    continue;
                }
                if ("enabledState".equals(fieldName)) {
                    deserializedRouteProperties.withEnabledState(EnabledState.fromString(reader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRouteProperties.provisioningState = AfdProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentStatus".equals(fieldName)) {
                    deserializedRouteProperties.deploymentStatus = DeploymentStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteProperties;
        });
    }
}

