// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Input of the validate probe API.
 */
@Fluent
public final class ValidateProbeInput implements JsonSerializable<ValidateProbeInput> {
    /*
     * The probe URL to validate.
     */
    private String probeUrl;

    /**
     * Creates an instance of ValidateProbeInput class.
     */
    public ValidateProbeInput() {
    }

    /**
     * Get the probeUrl property: The probe URL to validate.
     * 
     * @return the probeUrl value.
     */
    public String probeUrl() {
        return this.probeUrl;
    }

    /**
     * Set the probeUrl property: The probe URL to validate.
     * 
     * @param probeUrl the probeUrl value to set.
     * @return the ValidateProbeInput object itself.
     */
    public ValidateProbeInput withProbeUrl(String probeUrl) {
        this.probeUrl = probeUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (probeUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property probeUrl in model ValidateProbeInput"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ValidateProbeInput.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("probeURL", this.probeUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ValidateProbeInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ValidateProbeInput if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ValidateProbeInput.
     */
    public static ValidateProbeInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ValidateProbeInput deserializedValidateProbeInput = new ValidateProbeInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("probeURL".equals(fieldName)) {
                    deserializedValidateProbeInput.probeUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedValidateProbeInput;
        });
    }
}
