// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes a managed rule group.
 */
@Immutable
public final class ManagedRuleGroupDefinition implements JsonSerializable<ManagedRuleGroupDefinition> {
    /*
     * Name of the managed rule group.
     */
    private String ruleGroupName;

    /*
     * Description of the managed rule group.
     */
    private String description;

    /*
     * List of rules within the managed rule group.
     */
    private List<ManagedRuleDefinition> rules;

    /**
     * Creates an instance of ManagedRuleGroupDefinition class.
     */
    public ManagedRuleGroupDefinition() {
    }

    /**
     * Get the ruleGroupName property: Name of the managed rule group.
     * 
     * @return the ruleGroupName value.
     */
    public String ruleGroupName() {
        return this.ruleGroupName;
    }

    /**
     * Get the description property: Description of the managed rule group.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the rules property: List of rules within the managed rule group.
     * 
     * @return the rules value.
     */
    public List<ManagedRuleDefinition> rules() {
        return this.rules;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedRuleGroupDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedRuleGroupDefinition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedRuleGroupDefinition.
     */
    public static ManagedRuleGroupDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedRuleGroupDefinition deserializedManagedRuleGroupDefinition = new ManagedRuleGroupDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ruleGroupName".equals(fieldName)) {
                    deserializedManagedRuleGroupDefinition.ruleGroupName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedManagedRuleGroupDefinition.description = reader.getString();
                } else if ("rules".equals(fieldName)) {
                    List<ManagedRuleDefinition> rules
                        = reader.readArray(reader1 -> ManagedRuleDefinition.fromJson(reader1));
                    deserializedManagedRuleGroupDefinition.rules = rules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedRuleGroupDefinition;
        });
    }
}
