// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the response header action for the delivery rule.
 */
@Fluent
public final class DeliveryRuleResponseHeaderAction extends DeliveryRuleAction {
    /*
     * The name of the action for the delivery rule.
     */
    private DeliveryRuleActionValue name = DeliveryRuleActionValue.MODIFY_RESPONSE_HEADER;

    /*
     * Defines the parameters for the action.
     */
    private HeaderActionParameters parameters;

    /**
     * Creates an instance of DeliveryRuleResponseHeaderAction class.
     */
    public DeliveryRuleResponseHeaderAction() {
    }

    /**
     * Get the name property: The name of the action for the delivery rule.
     * 
     * @return the name value.
     */
    @Override
    public DeliveryRuleActionValue name() {
        return this.name;
    }

    /**
     * Get the parameters property: Defines the parameters for the action.
     * 
     * @return the parameters value.
     */
    public HeaderActionParameters parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Defines the parameters for the action.
     * 
     * @param parameters the parameters value to set.
     * @return the DeliveryRuleResponseHeaderAction object itself.
     */
    public DeliveryRuleResponseHeaderAction withParameters(HeaderActionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (parameters() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property parameters in model DeliveryRuleResponseHeaderAction"));
        } else {
            parameters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleResponseHeaderAction.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeliveryRuleResponseHeaderAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeliveryRuleResponseHeaderAction if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeliveryRuleResponseHeaderAction.
     */
    public static DeliveryRuleResponseHeaderAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeliveryRuleResponseHeaderAction deserializedDeliveryRuleResponseHeaderAction
                = new DeliveryRuleResponseHeaderAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleResponseHeaderAction.parameters = HeaderActionParameters.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleResponseHeaderAction.name
                        = DeliveryRuleActionValue.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeliveryRuleResponseHeaderAction;
        });
    }
}
